/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.system.componentArchitecture.ui.quickfix;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SupportedMiddleware;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitectureFactory;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitectureModelUtility;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.Connection;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.RequiredService;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.ui.quickfix.RoboticMiddlewareQuickfixProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ComponentArchitectureQuickfixProvider
extends RoboticMiddlewareQuickfixProvider {
    @Inject
    private IResourceSetProvider resourceSetProvider;

    @Fix(value="org.xtext.system.componentArchitecture.InvalidName")
    public void capitalizeName(Issue issue, IssueResolutionAcceptor acceptor) {
        IModification _function = context -> {
            IXtextDocument xtextDocument = context.getXtextDocument();
            String firstLetter = xtextDocument.get(issue.getOffset().intValue(), 1);
            xtextDocument.replace(issue.getOffset().intValue(), 1, firstLetter.toUpperCase());
        };
        acceptor.accept(issue, "Capitalize name", "Capitalize the name.", "upcase.png", _function);
    }

    @Fix(value="org.xtext.system.componentArchitecture.MissingPorts")
    public void addAllMissingPorts(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            ComponentInstance instance = (ComponentInstance)element;
            Iterable services = ComponentArchitectureModelUtility.getAllClientPorts((ComponentInstance)instance);
            for (ComponentPort svc : services) {
                boolean _not;
                Functions.Function1 _function_1 = it -> {
                    ComponentPort _port = it.getPort();
                    return Objects.equal((Object)_port, (Object)svc);
                };
                boolean _exists = IterableExtensions.exists((Iterable)instance.getPorts(), (Functions.Function1)_function_1);
                boolean bl = _not = !_exists;
                if (!_not) continue;
                RequiredService svc_use = ComponentArchitectureFactory.eINSTANCE.createRequiredService();
                svc_use.setPort(svc);
                instance.getPorts().add((Object)svc_use);
            }
        };
        acceptor.accept(issue, "Add all missing ports", "Add all missing ports", "", _function);
    }

    @Fix(value="org.xtext.system.componentArchitecture.MissingPorts")
    public void addNonOptionalMissingPorts(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            ComponentInstance instance = (ComponentInstance)element;
            Iterable services = ComponentArchitectureModelUtility.getNonOptionalClientPorts((ComponentInstance)instance);
            for (ComponentPort svc : services) {
                boolean _not;
                Functions.Function1 _function_1 = it -> {
                    ComponentPort _port = it.getPort();
                    return Objects.equal((Object)_port, (Object)svc);
                };
                boolean _exists = IterableExtensions.exists((Iterable)instance.getPorts(), (Functions.Function1)_function_1);
                boolean bl = _not = !_exists;
                if (!_not) continue;
                RequiredService svc_use = ComponentArchitectureFactory.eINSTANCE.createRequiredService();
                svc_use.setPort(svc);
                instance.getPorts().add((Object)svc_use);
            }
        };
        acceptor.accept(issue, "Add non-optional ports only", "Add non-optional ports only", "", _function);
    }

    @Fix(value="org.xtext.system.componentArchitecture.MiddlewareSelectionNotSupported")
    public void addChangeMiddlewareSelection(Issue issue, IssueResolutionAcceptor acceptor) {
        ResourceSet rsp = this.resourceSetProvider.get(null);
        EObject object = rsp.getEObject(issue.getUriToProblem(), true);
        if (object instanceof Connection) {
            Iterable _filter = Iterables.filter((Iterable)((Connection)object).getFrom().getPort().getExtensions(), SupportedMiddleware.class);
            for (SupportedMiddleware mw : _filter) {
                Functions.Function1 _function = it -> {
                    String _name = it.getMiddleware().eClass().getName();
                    String _name_1 = mw.getMiddleware().eClass().getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                };
                boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)((Connection)object).getTo().getPort().getExtensions(), SupportedMiddleware.class), (Functions.Function1)_function);
                if (!_exists) continue;
                String _name = mw.getMiddleware().eClass().getName();
                String text = "Change to " + _name;
                ISemanticModification _function_1 = (element, context) -> {
                    Connection connection = (Connection)element;
                    connection.setMiddlewareSelection(mw.getMiddleware());
                };
                acceptor.accept(issue, text, text, "", _function_1);
            }
        }
    }

    @Fix(value="org.xtext.system.componentArchitecture.DuplicateParameterStruct")
    public void fixDuplicateParameterStruct(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            EObject _eContainer = element.eContainer();
            ComponentInstance component = (ComponentInstance)_eContainer;
            component.getExtensions().remove((Object)element);
        };
        acceptor.accept(issue, "Remove duplicate ParameterStruct", "Remove duplicate ParameterStruct.", "", _function);
    }

    @Fix(value="org.xtext.system.componentArchitecture.InvalidParameterStruct")
    public void fixInvalidParameterStruct(Issue issue, IssueResolutionAcceptor acceptor) {
        String _get = issue.getData()[0];
        String _plus = "Change to " + _get;
        String _get_1 = issue.getData()[0];
        String _plus_1 = "Change to " + _get_1;
        IModification _function = context -> {
            IXtextDocument xtextDocument = context.getXtextDocument();
            xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), issue.getData()[0]);
        };
        acceptor.accept(issue, _plus, _plus_1, "", _function);
    }
}

