/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.designer.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.eclipse.smila.designer.json.JSONObject;

public final class JSONArray
implements Iterable<Object>,
Cloneable {
    private List<Object> values = new ArrayList<Object>();
    private Iterable<JSONObject> allObjects;

    public JSONArray() {
    }

    /*
     * Unable to fully structure code
     */
    public JSONArray(JsonParser parser) throws IOException {
        super();
        if (!parser.hasCurrentToken()) {
            parser.nextToken();
        }
        if (parser.getCurrentToken() == JsonToken.START_ARRAY) ** GOTO lbl10
        throw new JsonParseException("Expected start of array, found " + JSONObject.getTokenLabel(parser.getCurrentToken()), parser.getCurrentLocation());
lbl-1000:
        // 1 sources

        {
            this.values.add(JSONObject.readValue(parser));
lbl10:
            // 2 sources

            ** while (parser.nextToken() != JsonToken.END_ARRAY)
        }
lbl11:
        // 1 sources

    }

    public JSONArray clone() {
        try {
            JSONArray clone = (JSONArray)super.clone();
            clone.values = new ArrayList<Object>(this.values);
            ListIterator<Object> it = clone.values.listIterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof JSONObject) {
                    it.set(((JSONObject)o).clone());
                    continue;
                }
                if (!(o instanceof JSONArray)) continue;
                it.set(((JSONArray)o).clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj != this) {
            if (!(obj instanceof JSONArray)) {
                return false;
            }
            JSONArray other = (JSONArray)obj;
            if (this.values.size() != other.values.size()) {
                return false;
            }
            int i = 0;
            while (i < this.values.size()) {
                Object o1 = this.values.get(i);
                Object o2 = other.values.get(i);
                if (o1 == null ? o2 != null : !o1.equals(o2)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public Object get(int index) {
        return this.values.get(index);
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public int indexOf(Object value) {
        return this.values.indexOf(value);
    }

    public int indexOf(String key, Object value) {
        int i = 0;
        while (i < this.values.size()) {
            Object o = this.values.get(i);
            if (o instanceof JSONObject) {
                Object objValue = ((JSONObject)o).get(key);
                if (value == null ? objValue == null : value.equals(objValue)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public Iterable<JSONObject> allObjects() {
        if (this.allObjects == null) {
            this.allObjects = new Iterable<JSONObject>(){

                @Override
                public Iterator<JSONObject> iterator() {
                    return new JSONObjectIterator();
                }
            };
        }
        return this.allObjects;
    }

    public void add(Boolean value) {
        this.values.add(value);
    }

    public void add(int index, Boolean value) {
        this.values.add(index, value);
    }

    public void add(Number value) {
        this.values.add(value);
    }

    public void add(int index, Number value) {
        this.values.add(index, value);
    }

    public void add(String value) {
        this.values.add(value);
    }

    public void add(int index, String value) {
        this.values.add(index, value);
    }

    public void add(JSONObject value) {
        this.values.add(value);
    }

    public void add(int index, JSONObject value) {
        this.values.add(index, value);
    }

    public void add(JSONArray value) {
        this.values.add(value);
    }

    public void add(int index, JSONArray value) {
        this.values.add(index, value);
    }

    public void addNull() {
        this.values.add(null);
    }

    public void addNull(int index) {
        this.values.add(index, null);
    }

    public void addAll(JSONArray array) {
        this.values.addAll(array.values);
    }

    public Object remove(int index) {
        return this.values.remove(index);
    }

    public boolean remove(Object value) {
        int i = 0;
        while (i < this.values.size()) {
            if (this.values.get(i) == value) {
                this.values.remove(i);
                return true;
            }
            ++i;
        }
        return this.values.remove(value);
    }

    public void writeTo(JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        for (Object value : this.values) {
            JSONObject.writeValue(generator, value);
        }
        generator.writeEndArray();
    }

    public String toString() {
        return this.toString(new StringBuilder(this.values.size() * 10 + 2)).toString();
    }

    StringBuilder toString(StringBuilder result) {
        result.append('[');
        int i = 0;
        while (i < this.values.size()) {
            if (i > 0) {
                result.append(',');
            }
            JSONObject.toString(result, this.values.get(i));
            ++i;
        }
        return result.append(']');
    }

    private final class JSONObjectIterator
    implements Iterator<JSONObject> {
        private int index = this.findNext(0);

        private int findNext(int index) {
            while (index < JSONArray.this.values.size()) {
                if (!(JSONArray.this.values.get(index) instanceof JSONObject)) continue;
                return index;
            }
            return -1;
        }

        @Override
        public JSONObject next() {
            JSONObject next = (JSONObject)JSONArray.this.values.get(this.index);
            this.index = this.findNext(this.index + 1);
            return next;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

