/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.designer.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.eclipse.smila.designer.json.JSONArray;

public final class JSONObject
implements Iterable<Map.Entry<String, Object>>,
Cloneable {
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public JSONObject() {
    }

    /*
     * Unable to fully structure code
     */
    public JSONObject(JsonParser parser) throws IOException {
        super();
        if (!parser.hasCurrentToken()) {
            parser.nextToken();
        }
        if (parser.getCurrentToken() == JsonToken.START_OBJECT) ** GOTO lbl17
        throw new JsonParseException("Expected start of object, but found " + JSONObject.getTokenLabel(parser.getCurrentToken()), parser.getCurrentLocation());
lbl-1000:
        // 1 sources

        {
            if (parser.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw new JsonParseException("Expected field name, but found " + JSONObject.getTokenLabel(parser.getCurrentToken()), parser.getCurrentLocation());
            }
            key = parser.getText();
            if (this.properties.containsKey(key)) {
                throw new JsonParseException("The same key is used twice: " + key, parser.getCurrentLocation());
            }
            parser.nextToken();
            this.properties.put(key, JSONObject.readValue(parser));
lbl17:
            // 2 sources

            ** while (parser.nextToken() != JsonToken.END_OBJECT)
        }
lbl18:
        // 1 sources

    }

    public JSONObject clone() {
        try {
            JSONObject clone = (JSONObject)super.clone();
            clone.properties = new LinkedHashMap<String, Object>(this.properties);
            for (Map.Entry<String, Object> entry : clone.properties.entrySet()) {
                if (entry.getValue() instanceof JSONObject) {
                    entry.setValue(((JSONObject)entry.getValue()).clone());
                    continue;
                }
                if (!(entry.getValue() instanceof JSONArray)) continue;
                entry.setValue(((JSONArray)entry.getValue()).clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj != this) {
            if (!(obj instanceof JSONObject)) {
                return false;
            }
            JSONObject other = (JSONObject)obj;
            if (this.properties.size() != other.properties.size()) {
                return false;
            }
            Iterator<Map.Entry<String, Object>> it1 = this.properties.entrySet().iterator();
            Iterator<Map.Entry<String, Object>> it2 = other.properties.entrySet().iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Map.Entry<String, Object> entry1 = it1.next();
                Map.Entry<String, Object> entry2 = it2.next();
                if (entry1.getKey().equals(entry2.getKey()) && !(entry1.getValue() == null ? entry2.getValue() != null : !entry1.getValue().equals(entry2.getValue()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.properties.entrySet().iterator();
    }

    public Set<String> keySet() {
        return this.properties.keySet();
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public Boolean asBoolean(String key, Boolean defaultValue) {
        Object value = this.properties.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return "true".equals(value) ? Boolean.TRUE : ("false".equals(value) ? Boolean.FALSE : defaultValue);
        }
        return defaultValue;
    }

    public Number asNumber(String key, Number defaultValue) {
        Object value = this.properties.get(key);
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public String asString(String key) {
        Object value = this.properties.get(key);
        return value == null ? (this.properties.containsKey(key) ? "null" : null) : value.toString();
    }

    public JSONObject asObject(String key, boolean create) {
        Object value = this.properties.get(key);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        if (create) {
            JSONObject newValue = new JSONObject();
            this.properties.put(key, newValue);
            return newValue;
        }
        return null;
    }

    public JSONArray asArray(String key, boolean create) {
        Object value = this.properties.get(key);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (create) {
            JSONArray newValue = new JSONArray();
            this.properties.put(key, newValue);
            return newValue;
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public boolean replaceKey(String oldKey, String newKey) {
        if (this.properties.containsKey(newKey) || !this.properties.containsKey(oldKey)) {
            return false;
        }
        LinkedHashMap<String, Object> newProperties = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            if (oldKey.equals(key)) {
                key = newKey;
            }
            newProperties.put(key, entry.getValue());
        }
        this.properties = newProperties;
        return true;
    }

    public int size() {
        return this.properties.size();
    }

    public Object put(String key, Boolean value) {
        return this.properties.put(key, value);
    }

    public Object put(String key, Number value) {
        return this.properties.put(key, value);
    }

    public Object put(String key, String value) {
        return this.properties.put(key, value);
    }

    public Object put(String key, JSONObject value) {
        return this.properties.put(key, value);
    }

    public Object put(String key, JSONArray value) {
        return this.properties.put(key, value);
    }

    public Object putNull(String key) {
        return this.properties.put(key, null);
    }

    public Object remove(String key) {
        return this.properties.remove(key);
    }

    public void put(JSONObject object, String key) {
        Object value = object.properties.get(key);
        if (value != null || object.properties.containsKey(key)) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    public void putAll(JSONObject object) {
        this.putAll(object, false);
    }

    public void putAll(JSONObject object, boolean deep) {
        if (object == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : object.properties.entrySet()) {
            Object myObject;
            if (deep && (entry.getValue() instanceof JSONObject || entry.getValue() instanceof JSONArray) && (myObject = this.properties.get(entry.getKey())).getClass() == entry.getValue().getClass()) {
                if (myObject instanceof JSONObject) {
                    ((JSONObject)myObject).putAll((JSONObject)entry.getValue(), true);
                    continue;
                }
                ((JSONArray)myObject).addAll((JSONArray)entry.getValue());
                continue;
            }
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public void writeTo(JsonGenerator generator) throws JsonGenerationException, IOException {
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            generator.writeFieldName(entry.getKey());
            JSONObject.writeValue(generator, entry.getValue());
        }
        generator.writeEndObject();
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JsonGenerator generator = new JsonFactory().createJsonGenerator((OutputStream)out, JsonEncoding.UTF8);
            generator.useDefaultPrettyPrinter();
            this.writeTo(generator);
            generator.flush();
            generator.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toPrettyString() {
        try {
            StringWriter out = new StringWriter();
            JsonGenerator generator = new JsonFactory().createJsonGenerator((Writer)out);
            generator.useDefaultPrettyPrinter();
            this.writeTo(generator);
            generator.flush();
            generator.close();
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeValue(JsonGenerator generator, Object value) throws IOException {
        if (value instanceof String) {
            generator.writeString((String)value);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            if (number instanceof Integer) {
                generator.writeNumber(number.intValue());
            } else if (number instanceof Long) {
                generator.writeNumber(number.longValue());
            } else if (number instanceof BigInteger) {
                generator.writeNumber((BigInteger)number);
            } else if (number instanceof Float) {
                generator.writeNumber(number.floatValue());
            } else if (number instanceof BigDecimal) {
                generator.writeNumber((BigDecimal)number);
            } else {
                generator.writeNumber(number.doubleValue());
            }
        } else if (value instanceof Boolean) {
            generator.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).writeTo(generator);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).writeTo(generator);
        } else if (value == null) {
            generator.writeNull();
        } else {
            throw new IllegalStateException("Unexpted value type: " + value.getClass());
        }
    }

    static Object readValue(JsonParser parser) throws IOException {
        switch (parser.getCurrentToken()) {
            case START_ARRAY: {
                return new JSONArray(parser);
            }
            case START_OBJECT: {
                return new JSONObject(parser);
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: {
                return parser.getText();
            }
            case VALUE_NUMBER_FLOAT: {
                return parser.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return parser.getLongValue();
            }
        }
        throw new JsonParseException("Expected value, found " + JSONObject.getTokenLabel(parser.getCurrentToken()), parser.getCurrentLocation());
    }

    public String toString() {
        return this.toString(new StringBuilder(this.properties.size() * 10 + 2)).toString();
    }

    StringBuilder toString(StringBuilder result) {
        result.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            JSONObject.toString(result.append(entry.getKey()).append(':'), entry.getValue());
        }
        return result.append('}');
    }

    static void toString(StringBuilder result, Object value) {
        if (value instanceof String) {
            result.append('\"').append(value).append('\"');
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).toString(result);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).toString(result);
        } else {
            result.append(value);
        }
    }

    static String getTokenLabel(JsonToken token) {
        if (token == null) {
            return "end of file";
        }
        if (token.asString() != null) {
            return String.valueOf(token.toString()) + " (" + token.asString() + ")";
        }
        return token.toString();
    }
}

