/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.designer.json;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.smila.designer.json.JSONObject;

public class ServerConnectionException
extends IOException {
    private static final long serialVersionUID = -6293990734451401845L;
    private static final String MESSAGE_KEY = "message";
    private final int responseCode;
    private final JSONObject responseObject;
    private final String path;

    public ServerConnectionException(String path, int responseCode, JSONObject responseObject) {
        this.path = path;
        this.responseCode = responseCode;
        this.responseObject = responseObject;
    }

    public ServerConnectionException(String path, int responseCode, String responseMessage) {
        this.path = path;
        this.responseCode = responseCode;
        this.responseObject = new JSONObject();
        this.responseObject.put(MESSAGE_KEY, responseMessage);
    }

    public String getPath() {
        return this.path;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    public String getMessage() {
        String message = this.responseObject.asString(MESSAGE_KEY);
        if (message == null) {
            try {
                message = new String(this.responseObject.toByteArray(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return message;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.path + ")";
    }
}

