/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.model.processor.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMUtils {
    private static final int INDENT_SIZE = 4;

    public static String readTextContent(Element element) {
        StringBuilder textContent = new StringBuilder();
        Node child = element.getFirstChild();
        while (child != null) {
            if (child instanceof Text) {
                textContent.append(child.getNodeValue());
            }
            child = child.getNextSibling();
        }
        return textContent.toString();
    }

    public static void writeTextContent(Element element, String text) {
        Node child = element.getFirstChild();
        while (child != null) {
            if (child instanceof Text || child instanceof CDATASection) {
                child.setNodeValue(text);
                while (child != null) {
                    Node node = child;
                    child = child.getNextSibling();
                    if (!(node instanceof Text) && !(node instanceof CDATASection)) continue;
                    element.removeChild(child);
                }
                return;
            }
            child = child.getNextSibling();
        }
        element.appendChild(element.getOwnerDocument().createTextNode(text));
    }

    public static Element getNextElement(Node node) {
        while (node != null) {
            if (!((node = node.getNextSibling()) instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public static List<Element> getChildElements(Element parentElement, String namespaceURI, String ... localNames) {
        List<Element> result = null;
        List<Object> names = localNames == null || localNames.length == 0 ? Collections.emptyList() : Arrays.asList(localNames);
        Node child = parentElement.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                Element element = (Element)child;
                if ((namespaceURI == null || namespaceURI.equals(element.getNamespaceURI())) && (names.isEmpty() || names.contains(element.getLocalName()))) {
                    if (result == null) {
                        result = new ArrayList<Element>();
                    }
                    result.add(element);
                }
            }
            child = child.getNextSibling();
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static Element getChildElement(Element parentElement, String namespaceURI, String localName) {
        Node child = parentElement.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                Element element = (Element)child;
                if ((namespaceURI == null || namespaceURI.equals(element.getNamespaceURI())) && localName.equals(element.getLocalName())) {
                    return element;
                }
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static final void appendIndented(Node parent, Node child) {
        DOMUtils.insertIndented(parent, child, null);
    }

    /*
     * Unable to fully structure code
     */
    public static final void insertIndented(Node parent, Node child, Node before) {
        block3: {
            document = parent.getOwnerDocument();
            v0 = previous = before == null ? parent.getLastChild() : before.getPreviousSibling();
            if (previous != null) ** GOTO lbl14
            indent = DOMUtils.calculateIndention(parent);
            text = document.createTextNode(DOMUtils.createIndent(before != null ? indent + 4 : indent));
            parent.insertBefore(text, before);
            parent.insertBefore(child, text);
            parent.insertBefore(document.createTextNode(DOMUtils.createIndent(indent + 4)), child);
            break block3;
lbl-1000:
            // 1 sources

            {
                previous = previous.getPreviousSibling();
lbl14:
                // 2 sources

                ** while (!(previous instanceof Element) && previous != null)
            }
lbl15:
            // 1 sources

            if (previous == null) {
                indent = DOMUtils.calculateIndention(parent) + 4;
                parent.insertBefore(child, parent.getFirstChild());
            } else {
                indent = DOMUtils.calculateIndention(previous);
                parent.insertBefore(child, previous.getNextSibling());
            }
            parent.insertBefore(document.createTextNode(DOMUtils.createIndent(indent)), child);
        }
    }

    public static final void removeIndented(Node child) {
        Node parent = child.getParentNode();
        while (DOMUtils.isWhitespaceText(child.getPreviousSibling())) {
            parent.removeChild(child.getPreviousSibling());
        }
        parent.removeChild(child);
    }

    private static final boolean isWhitespaceText(Node node) {
        if (node instanceof Text) {
            String text = node.getNodeValue();
            int i = text.length() - 1;
            while (i >= 0) {
                if (!Character.isWhitespace(text.charAt(i))) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    private static int calculateIndention(Node node) {
        int indent = 0;
        while (node != null) {
            Node previous = node.getPreviousSibling();
            while (previous != null) {
                if (previous instanceof Text) {
                    String text = previous.getNodeValue();
                    int i = text.length() - 1;
                    while (i >= 0) {
                        switch (text.charAt(i)) {
                            case '\n': {
                                return indent;
                            }
                            case '\t': {
                                indent += 4;
                            }
                            case '\r': {
                                break;
                            }
                            default: {
                                ++indent;
                            }
                        }
                        --i;
                    }
                }
                previous = previous.getPreviousSibling();
            }
            node = node.getParentNode();
        }
        return indent;
    }

    private static final String createIndent(int size) {
        StringBuilder result = new StringBuilder(size + 1).append('\n');
        while (size-- > 0) {
            result.append(' ');
        }
        return result.toString();
    }
}

