/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.model.processor.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.extensions.BPELActivityDeserializer;
import org.eclipse.bpel.model.resource.BPELReader;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.smila.processing.designer.model.processor.Configuration;
import org.eclipse.smila.processing.designer.model.processor.InvokePipelet;
import org.eclipse.smila.processing.designer.model.processor.Pipelet;
import org.eclipse.smila.processing.designer.model.processor.ProcessorFactory;
import org.eclipse.smila.processing.designer.model.processor.Variables;
import org.eclipse.smila.processing.designer.model.processor.util.DOMUtils;
import org.eclipse.smila.processing.designer.model.processor.util.ProcessorConstants;
import org.eclipse.smila.processing.designer.model.record.RecordAny;
import org.eclipse.smila.processing.designer.model.record.RecordFactory;
import org.eclipse.smila.processing.designer.model.record.RecordMap;
import org.eclipse.smila.processing.designer.model.record.RecordSeq;
import org.eclipse.smila.processing.designer.model.record.RecordVal;
import org.eclipse.smila.processing.designer.model.record.RecordValues;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InvokePipeletDeserializer
implements BPELActivityDeserializer {
    public Activity unmarshall(QName elementType, Node node, Activity activity, Process process, Map nsMap, ExtensionRegistry extReg, URI uri, BPELReader bpelReader) {
        if ("invokePipelet".equals(elementType.getLocalPart()) && ProcessorConstants.NS_URI.equals(elementType.getNamespaceURI()) && node instanceof Element) {
            Element configurationElement;
            Element invokePipeletElement = (Element)node;
            InvokePipelet invokePipelet = activity instanceof InvokePipelet ? (InvokePipelet)activity : ProcessorFactory.eINSTANCE.createInvokePipelet();
            invokePipelet.setElement((Element)invokePipeletElement.getParentNode());
            Element pipeletElement = DOMUtils.getChildElement(invokePipeletElement, ProcessorConstants.NS_URI, "pipelet");
            if (pipeletElement == null) {
                invokePipelet.setPipelet(null);
            } else {
                Pipelet pipelet = invokePipelet.getPipelet();
                if (pipelet == null) {
                    pipelet = ProcessorFactory.eINSTANCE.createPipelet();
                }
                if (pipeletElement != pipelet.getElement()) {
                    pipelet.setElement(pipeletElement);
                }
                pipelet.setClass(pipeletElement.getAttribute("class"));
                if (invokePipelet.getPipelet() != pipelet) {
                    invokePipelet.setPipelet(pipelet);
                }
            }
            Element variablesElement = DOMUtils.getChildElement(invokePipeletElement, ProcessorConstants.NS_URI, "variables");
            if (variablesElement == null) {
                invokePipelet.setVariables(null);
            } else {
                Variables variables = invokePipelet.getVariables();
                if (variables == null) {
                    variables = ProcessorFactory.eINSTANCE.createVariables();
                }
                if (variablesElement != variables.getElement()) {
                    variables.setElement(variablesElement);
                }
                variables.setInput(variablesElement.getAttribute("input"));
                variables.setOutput(variablesElement.getAttribute("output"));
                variables.setIndex(variablesElement.getAttribute("index"));
                if (invokePipelet.getVariables() != variables) {
                    invokePipelet.setVariables(variables);
                }
            }
            Configuration configuration = invokePipelet.getConfiguration();
            if (configuration == null) {
                configuration = ProcessorFactory.eINSTANCE.createConfiguration();
            }
            if ((configurationElement = DOMUtils.getChildElement(invokePipeletElement, ProcessorConstants.NS_URI, "configuration")) != configuration.getElement()) {
                configuration.setElement(configurationElement);
            }
            if (configurationElement == null) {
                configuration.getValues().clear();
            } else {
                this.readMap(configurationElement, configuration);
            }
            if (invokePipelet.getConfiguration() != configuration) {
                invokePipelet.setConfiguration(configuration);
            }
            return invokePipelet;
        }
        System.err.println("Cannot handle this kind of element");
        return null;
    }

    private RecordMap readMap(Element element, RecordMap map) {
        this.readValues(element, map, true);
        return map;
    }

    private RecordSeq readSeq(Element element, RecordSeq seq) {
        this.readValues(element, seq, false);
        return seq;
    }

    private void readValues(Element element, RecordValues parent, boolean readKeys) {
        if (parent.getElement() != element) {
            parent.setElement(element);
        }
        EList<RecordAny> values = parent.getValues();
        ArrayList<Element> elements = new ArrayList<Element>();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            RecordAny any = (RecordAny)it.next();
            Element oldElement = any.getElement();
            if (oldElement == null || oldElement.getParentNode() != element) {
                any.setElement(null);
                it.remove();
                continue;
            }
            elements.add(oldElement);
        }
        int currentIndex = 0;
        Node child = element.getFirstChild();
        while (child != null) {
            block11: {
                RecordAny value;
                Element childElement;
                block13: {
                    int index;
                    block12: {
                        if (!(child instanceof Element)) break block11;
                        childElement = (Element)child;
                        index = elements.indexOf(childElement);
                        if (index >= 0) break block12;
                        value = this.createValue(childElement);
                        if (value == null) break block11;
                        values.add(currentIndex, (Object)value);
                        elements.add(currentIndex, childElement);
                        break block13;
                    }
                    value = (RecordAny)values.get(index);
                    if (index > currentIndex) {
                        values.move(currentIndex, index);
                        elements.remove(index);
                        elements.add(currentIndex, childElement);
                    }
                    this.readValue(value);
                }
                ++currentIndex;
                String key = childElement.getAttribute("key");
                if (key.length() > 0) {
                    if (!key.equals(value.getKey())) {
                        value.setKey(key);
                    }
                    if (!readKeys) {
                        System.err.println("Found sequence value with key!");
                    }
                } else {
                    if (value.getKey() != null) {
                        value.setKey(null);
                    }
                    if (readKeys) {
                        System.err.println("Found map value without key!");
                    }
                }
            }
            child = child.getNextSibling();
        }
    }

    private RecordAny readVal(Element element, RecordVal val) {
        RecordVal.Type valueType;
        String type;
        if (element != val.getElement()) {
            val.setElement(element);
        }
        if ((type = element.getAttribute("type")).length() == 0) {
            valueType = RecordVal.Type.STRING;
        } else {
            try {
                valueType = RecordVal.Type.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return val;
            }
        }
        String textContent = DOMUtils.readTextContent(element);
        try {
            Object object = valueType.parse(textContent);
            if (!(object == val.getValue() || object != null && object.equals(val.getValue()))) {
                val.setValue(object);
            }
        }
        catch (ParseException parseException) {}
        return val;
    }

    private RecordAny createValue(Element element) {
        if ("http://www.eclipse.org/smila/record".equals(element.getNamespaceURI())) {
            if ("Map".equals(element.getLocalName())) {
                return this.readMap(element, RecordFactory.eINSTANCE.createRecordMap());
            }
            if ("Seq".equals(element.getLocalName())) {
                return this.readSeq(element, RecordFactory.eINSTANCE.createRecordSeq());
            }
            if ("Val".equals(element.getLocalName())) {
                return this.readVal(element, RecordFactory.eINSTANCE.createRecordVal());
            }
        }
        System.err.println("Unknown record element: " + element.getNodeName());
        return null;
    }

    private void readValue(RecordAny value) {
        if (value.isMap()) {
            this.readMap(value.getElement(), (RecordMap)value);
        } else if (value.isSeq()) {
            this.readSeq(value.getElement(), (RecordSeq)value);
        } else if (value.isVal()) {
            this.readVal(value.getElement(), (RecordVal)value);
        }
    }
}

