/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.model.processor.util;

import javax.xml.namespace.QName;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.extensions.BPELActivitySerializer;
import org.eclipse.bpel.model.resource.BPELWriter;
import org.eclipse.smila.processing.designer.model.processor.InvokePipelet;
import org.eclipse.smila.processing.designer.model.processor.Pipelet;
import org.eclipse.smila.processing.designer.model.processor.Variables;
import org.eclipse.smila.processing.designer.model.processor.util.ProcessorUtils;
import org.eclipse.smila.processing.designer.model.record.RecordAny;
import org.eclipse.smila.processing.designer.model.record.RecordMap;
import org.eclipse.smila.processing.designer.model.record.RecordSeq;
import org.eclipse.smila.processing.designer.model.record.RecordVal;
import org.eclipse.smila.processing.designer.model.record.util.RecordUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InvokePipeletSerializer
implements BPELActivitySerializer {
    public void marshall(QName elementType, Activity activity, Node parentNode, Process process, BPELWriter bpelWriter) {
        Document document = parentNode.getOwnerDocument();
        if (activity instanceof InvokePipelet) {
            InvokePipelet invokePipelet = (InvokePipelet)activity;
            Element elementInvokePipelet = document.createElementNS(elementType.getNamespaceURI(), "invokePipelet");
            elementInvokePipelet.setPrefix(ProcessorUtils.addNamespace(process));
            parentNode.appendChild(elementInvokePipelet);
            Pipelet pipelet = invokePipelet.getPipelet();
            Element elementPipelet = document.createElementNS(elementType.getNamespaceURI(), "pipelet");
            elementPipelet.setPrefix("proc");
            String className = pipelet.getClass_();
            elementPipelet.setAttribute("class", className == null ? "" : className);
            elementInvokePipelet.appendChild(elementPipelet);
            Variables variables = invokePipelet.getVariables();
            Element elementVariables = document.createElementNS(elementType.getNamespaceURI(), "variables");
            elementVariables.setPrefix("proc");
            elementVariables.setAttribute("input", variables.getInput());
            if (variables.getOutput() != null) {
                elementVariables.setAttribute("output", variables.getOutput());
            }
            if (variables.getIndex() != null) {
                elementVariables.setAttribute("index", variables.getIndex());
            }
            elementInvokePipelet.appendChild(elementVariables);
            Element elementConfiguration = document.createElementNS(elementType.getNamespaceURI(), "configuration");
            elementConfiguration.setPrefix("proc");
            elementInvokePipelet.appendChild(elementConfiguration);
            this.writeMap(invokePipelet.getConfiguration(), elementConfiguration, process);
        }
    }

    private void writeMap(RecordMap map, Element element, Process process) {
        for (RecordAny value : map.getValues()) {
            this.writeValue(value, element, process).setAttribute("key", value.getKey());
        }
    }

    private void writeSeq(RecordSeq seq, Element element, Process process) {
        for (RecordAny value : seq.getValues()) {
            this.writeValue(value, element, process);
        }
    }

    private Element writeValue(RecordAny value, Element parent, Process process) {
        Element element;
        if (value.isMap()) {
            element = parent.getOwnerDocument().createElementNS(parent.getNamespaceURI(), "Map");
            this.writeMap((RecordMap)value, element, process);
        } else if (value.isSeq()) {
            element = parent.getOwnerDocument().createElementNS(parent.getNamespaceURI(), "Seq");
            this.writeSeq((RecordSeq)value, element, process);
        } else {
            element = parent.getOwnerDocument().createElementNS(parent.getNamespaceURI(), "Val");
            RecordVal val = (RecordVal)value;
            RecordVal.Type type = val.getType();
            if (type != null) {
                if (type != RecordVal.Type.STRING) {
                    element.setAttribute("type", type.toString().toLowerCase());
                }
                element.setTextContent(type.format(val.getValue()));
            }
        }
        element.setPrefix(RecordUtils.addNamespace(process));
        parent.appendChild(element);
        return element;
    }
}

