/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.model.record;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.smila.processing.designer.model.Messages;
import org.eclipse.smila.processing.designer.model.record.RecordAny;

public interface RecordVal
extends RecordAny {
    public Object getValue();

    public void setValue(Object var1);

    public Type getType();

    public static enum Type {
        STRING(Messages.RecordVal_Type_String, (Class)String.class){

            @Override
            public Object parse(String text) throws ParseException {
                return text;
            }
        }
        ,
        LONG(Messages.RecordVal_Type_Long, (Class)Long.class){

            @Override
            public String format(Object o, Locale locale) {
                return NumberFormat.getNumberInstance(locale).format(o);
            }

            @Override
            public Object parse(String text) throws ParseException {
                try {
                    return text.indexOf(".") >= 0 ? (long)Double.parseDouble(text) : Long.parseLong(text);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(e.toString(), 0);
                }
            }

            @Override
            public Object parse(String text, Locale locale) throws ParseException {
                return NumberFormat.getNumberInstance(locale).parse(text);
            }
        }
        ,
        DOUBLE(Messages.RecordVal_Type_Double, (Class)Double.class){

            @Override
            public String format(Object o, Locale locale) {
                return NumberFormat.getNumberInstance(locale).format(o);
            }

            @Override
            public Object parse(String text) throws ParseException {
                try {
                    return Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(e.toString(), 0);
                }
            }

            @Override
            public Object parse(String text, Locale locale) throws ParseException {
                return NumberFormat.getNumberInstance(locale).parse(text);
            }
        }
        ,
        BOOLEAN(Messages.RecordVal_Type_Boolean, (Class)Boolean.class){

            @Override
            public String format(Object o, Locale locale) {
                return Boolean.TRUE.equals(o) ? Messages.RecordVal_Type_Boolean_True : Messages.RecordVal_Type_Boolean_False;
            }

            @Override
            public Object parse(String text) throws ParseException {
                return "true".equals(text);
            }

            @Override
            public Object parse(String text, Locale locale) throws ParseException {
                return Messages.RecordVal_Type_Boolean_True.equals(text);
            }
        }
        ,
        DATE(Messages.RecordVal_Type_Date, (Class)java.sql.Date.class){
            DateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);

            @Override
            public String format(Object o) {
                return this.format.format(o);
            }

            @Override
            public String format(Object o, Locale locale) {
                return DateFormat.getDateInstance(3, locale).format(o);
            }

            @Override
            public Object parse(String text) throws ParseException {
                return new java.sql.Date(this.format.parse(text).getTime());
            }

            @Override
            public Object parse(String text, Locale locale) throws ParseException {
                return DateFormat.getDateInstance(3, locale).parse(text);
            }
        }
        ,
        DATETIME(Messages.RecordVal_Type_Timestamp, (Class)Timestamp.class){
            DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH);

            @Override
            public String format(Object o) {
                return this.format.format(o);
            }

            @Override
            public String format(Object o, Locale locale) {
                return DateFormat.getDateTimeInstance(3, 3, locale).format(o);
            }

            @Override
            public Object parse(String text) throws ParseException {
                return new Timestamp(this.format.parse(text).getTime());
            }

            @Override
            public Object parse(String text, Locale locale) throws ParseException {
                return DateFormat.getDateTimeInstance(3, 3, locale).parse(text);
            }
        };

        public final Class<?> instanceClass;
        public final String label;

        public static Type getType(Object value) {
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (type.instanceClass.isInstance(value)) {
                    return type;
                }
                ++n2;
            }
            if (value instanceof Date) {
                return DATETIME;
            }
            if (value instanceof Float) {
                return DOUBLE;
            }
            if (value instanceof Number) {
                return LONG;
            }
            if (value instanceof CharSequence) {
                return STRING;
            }
            return null;
        }

        private Type(String label, Class<?> instanceClass) {
            this.label = label;
            this.instanceClass = instanceClass;
        }

        public String format(Object o) {
            return String.valueOf(o);
        }

        public String format(Object o, Locale locale) {
            return this.format(o);
        }

        public abstract Object parse(String var1) throws ParseException;

        public Object parse(String text, Locale locale) throws ParseException {
            return this.parse(text);
        }
    }
}

