/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.model.record.impl;

import java.text.ParseException;
import org.eclipse.bpel.model.util.ReconciliationHelper;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.smila.processing.designer.model.processor.util.DOMUtils;
import org.eclipse.smila.processing.designer.model.record.RecordPackage;
import org.eclipse.smila.processing.designer.model.record.RecordVal;
import org.eclipse.smila.processing.designer.model.record.impl.RecordAnyImpl;
import org.eclipse.wst.wsdl.WSDLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RecordValImpl
extends RecordAnyImpl
implements RecordVal {
    protected static final Object VALUE_EDEFAULT = null;
    protected Object value = VALUE_EDEFAULT;

    protected RecordValImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return RecordPackage.Literals.RECORD_VAL;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object newValue) {
        RecordVal.Type type = RecordVal.Type.getType(newValue);
        if (type == null) {
            throw new IllegalArgumentException("That type is not allowed for a value!");
        }
        Object oldValue = this.value;
        this.value = newValue;
        if (this.shouldReconcile()) {
            try {
                boolean equals;
                this.setUpdatingDOM(true);
                try {
                    String content = DOMUtils.readTextContent(this.getElement());
                    equals = this.value == null ? content.length() == 0 : this.value.equals(type.parse(content));
                }
                catch (ParseException parseException) {
                    equals = false;
                }
                if (!equals) {
                    DOMUtils.writeTextContent(this.getElement(), type.format(newValue));
                }
            }
            finally {
                this.setUpdatingDOM(false);
            }
            ReconciliationHelper.replaceAttribute((WSDLElement)this, (String)"type", type == RecordVal.Type.STRING ? null : type.toString().toLowerCase());
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldValue, this.value));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setValue(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean isVal() {
        return true;
    }

    @Override
    public RecordVal.Type getType() {
        return this.value == null ? null : RecordVal.Type.getType(this.value);
    }

    @Override
    protected Element createFixedElement(Document document) {
        RecordVal.Type type;
        Element element = document.createElementNS("http://www.eclipse.org/smila/record", "Val");
        element.setPrefix("rec");
        if (this.getKey() != null) {
            element.setAttribute("key", this.getKey());
        }
        if ((type = this.getType()) != null) {
            if (type != RecordVal.Type.STRING) {
                element.setAttribute("type", type.name().toLowerCase());
            }
            element.appendChild(document.createTextNode(type.format(this.getValue())));
        }
        return element;
    }
}

