/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.designer.pipelets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.smila.designer.pipelets.PipeletDefinition;
import org.eclipse.smila.designer.pipelets.PipeletHandler;

public final class PipeletRegistry {
    public static final String HANDLERS_EXTENSION_POINT = "org.eclipse.smila.designer.pipelets.handler";
    public static final String FILE_NAME = "pipelets.json";
    public static final String KEY_PIPELETS = "pipelets";
    private final List<PipeletHandler> handlers;
    public static final PipeletRegistry INSTANCE = new PipeletRegistry();

    private PipeletRegistry() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        this.handlers = new ArrayList<PipeletHandler>();
        if (registry != null && (elements = registry.getConfigurationElementsFor(HANDLERS_EXTENSION_POINT)) != null) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("PipeletHandler")) {
                    try {
                        this.handlers.add((PipeletHandler)element.createExecutableExtension("class"));
                    }
                    catch (CoreException coreException) {}
                }
                ++n2;
            }
        }
    }

    public Map<String, PipeletDefinition> getPipelets(IProject project) {
        if (this.handlers.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, PipeletDefinition> result = this.handlers.get(0).getPipelets(project);
        if (this.handlers.size() > 0) {
            result = new HashMap<String, PipeletDefinition>(result);
            int i = 1;
            while (i < this.handlers.size()) {
                result.putAll(this.handlers.get(i).getPipelets(project));
                ++i;
            }
        }
        return result;
    }
}

