/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.designer.pipelets;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.smila.designer.json.JSONArray;
import org.eclipse.smila.designer.json.JSONObject;
import org.eclipse.smila.designer.pipelets.ItemDescription;
import org.eclipse.smila.designer.pipelets.RecordDescription;

public class ValueDescription
extends RecordDescription {
    private final Type type;
    private final String defaultValue;
    private final Pattern pattern;
    private final Map<String, ItemDescription> items;

    public ValueDescription(JSONObject element) {
        Type type;
        try {
            type = Type.valueOf(element.asString("type").toUpperCase());
        }
        catch (RuntimeException runtimeException) {
            type = Type.STRING;
        }
        this.type = type;
        this.defaultValue = element.asString("default");
        String patternString = element.asString("pattern");
        if (patternString == null) {
            this.pattern = null;
        } else {
            Pattern pattern;
            try {
                pattern = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                pattern = null;
            }
            this.pattern = pattern;
        }
        JSONArray values = element.asArray("values", false);
        if (values == null || values.size() == 0) {
            this.items = Collections.emptyMap();
        } else {
            HashMap<String, ItemDescription> items = new HashMap<String, ItemDescription>();
            for (Object child : values) {
                ItemDescription item = new ItemDescription(child);
                if (item.getValue() == null) continue;
                items.put(item.getValue(), item);
            }
            this.items = Collections.unmodifiableMap(items);
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Map<String, ItemDescription> getItems() {
        return this.items;
    }

    public static enum Type {
        STRING,
        LONG,
        DOUBLE,
        BOOLEAN,
        DATE,
        DATETIME;

    }
}

