/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.designer.product.pipelets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.smila.designer.json.JSONObject;
import org.eclipse.smila.designer.product.Messages;
import org.eclipse.smila.designer.product.SMILADesignerProductPlugin;
import org.eclipse.smila.designer.product.pipelets.SMILAServer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class DownloadDefinitionsDialog
extends TitleAreaDialog {
    private static final QualifiedName HOST_PROPERTY = new QualifiedName(DownloadDefinitionsDialog.class.getName(), "host");
    private static final QualifiedName PORT_PROPERTY = new QualifiedName(DownloadDefinitionsDialog.class.getName(), "port");
    private static final Pattern VALID_HOST_NAMES = Pattern.compile("([-_A-Za-z0-9]){1,63}(\\.([-_A-Za-z0-9]){1,63})*\\.?");
    private final IProject project;
    private String host;
    private int port;

    public DownloadDefinitionsDialog(IProject project, Shell parentShell) {
        super(parentShell);
        this.project = project;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.DownloadDefinitionsDialog_Header);
        this.getShell().setText(Messages.DownloadDefinitionsDialog_Title);
        this.validateInput();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.defaultsFor((Control)composite).grab(true, true).applyTo((Control)composite);
        if (this.host == null) {
            try {
                this.host = this.project.getPersistentProperty(HOST_PROPERTY);
            }
            catch (CoreException coreException) {}
            if (this.host == null || this.host.length() == 0) {
                this.host = "localhost";
            }
        }
        if (this.port <= 0) {
            this.port = 8050;
            try {
                this.port = Integer.parseInt(this.project.getPersistentProperty(PORT_PROPERTY));
            }
            catch (Exception exception) {}
        }
        Label hostLabel = new Label(composite, 0);
        hostLabel.setText(Messages.DownloadDefinitionsDialog_HostLabel);
        final Text hostField = new Text(composite, 2048);
        hostField.setText(this.host);
        hostField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DownloadDefinitionsDialog.this.host = hostField.getText();
                DownloadDefinitionsDialog.this.validateInput();
            }
        });
        Label portLabel = new Label(composite, 0);
        portLabel.setText(Messages.DownloadDefinitionsDialog_PortLabel);
        final Spinner portField = new Spinner(composite, 2048);
        portField.setMinimum(0);
        portField.setMaximum(Integer.MAX_VALUE);
        portField.setValues(this.port, 0, Integer.MAX_VALUE, 0, 1, 100);
        portField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DownloadDefinitionsDialog.this.port = portField.getSelection();
                DownloadDefinitionsDialog.this.validateInput();
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).generateLayout(composite);
        return composite;
    }

    private void validateInput() {
        if (this.host == null || this.host.length() == 0 || !VALID_HOST_NAMES.matcher(this.host).matches()) {
            this.setMessage(Messages.DownloadDefinitionsDialog_InvalidHostName, 3);
            return;
        }
        this.setMessage(Messages.DownloadDefinitionsDialog_Description);
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        this.getButton(0).setEnabled(newType != 3);
    }

    protected void okPressed() {
        try {
            this.project.setPersistentProperty(HOST_PROPERTY, this.host);
            this.project.setPersistentProperty(PORT_PROPERTY, String.valueOf(this.port));
            SMILAServer server = new SMILAServer(this.host, this.port);
            JSONObject pipelets = server.getConnection().expand("/smila/pipelets/");
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            JsonGenerator generator = new JsonFactory().createJsonGenerator((OutputStream)buffer, JsonEncoding.UTF8);
            generator.useDefaultPrettyPrinter();
            pipelets.writeTo(generator);
            generator.flush();
            generator.close();
            IFolder settingsFolder = this.project.getFolder(".smila");
            if (!settingsFolder.exists()) {
                settingsFolder.create(false, true, null);
            }
            ByteArrayInputStream bytes = new ByteArrayInputStream(buffer.toByteArray());
            IFile file = settingsFolder.getFile("pipelets.json");
            if (!file.exists()) {
                file.create((InputStream)bytes, false, null);
            } else {
                file.setContents((InputStream)bytes, false, true, null);
            }
            super.okPressed();
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.DownloadDefinitionsDialog_ErrorDialogTitle, (String)Messages.DownloadDefinitionsDialog_ErrorDialogMessage, (IStatus)(e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : new Status(4, "org.eclipse.smila.designer.product", e.toString())));
            SMILADesignerProductPlugin.logError("Could not download definitions: " + e, e);
        }
    }
}

