/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.designer.product.pipelets;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.smila.designer.json.JSONObject;
import org.eclipse.smila.designer.pipelets.PipeletDefinition;
import org.eclipse.smila.designer.pipelets.PipeletHandler;
import org.eclipse.smila.designer.product.SMILADesignerProductPlugin;

public class SMILAPipeletHandler
implements PipeletHandler {
    public static final String SETTINGS_FOLDER = ".smila";
    public static final String FILE_NAME = "pipelets.json";
    public static final String KEY_PIPELETS = "pipelets";
    private static final QualifiedName STATE_KEY = new QualifiedName("org.eclipse.smila.designer.product", "pipelets.json");

    public Map<String, PipeletDefinition> getPipelets(IProject project) {
        block10: {
            try {
                IFile file = project.getFolder(SETTINGS_FOLDER).getFile(FILE_NAME);
                if (!file.exists()) break block10;
                State state = (State)project.getSessionProperty(STATE_KEY);
                long lastModified = file.getModificationStamp();
                if (state == null || state.lastModified != lastModified) {
                    try {
                        state = new State();
                        state.lastModified = lastModified;
                        state.descriptions = new HashMap();
                        InputStream in = file.getContents();
                        try {
                            JSONObject json = new JSONObject(new JsonFactory().createJsonParser(in));
                            for (JSONObject child : json.asArray(KEY_PIPELETS, true).allObjects()) {
                                PipeletDefinition description = new PipeletDefinition(child);
                                state.descriptions.put(description.getClassName(), description);
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    finally {
                        project.setSessionProperty(STATE_KEY, (Object)state);
                    }
                }
                return state.descriptions;
            }
            catch (Exception e) {
                SMILADesignerProductPlugin.logError("Could not read pipelet descriptions", e);
            }
        }
        return Collections.emptyMap();
    }

    private static final class State {
        private long lastModified;
        private Map<String, PipeletDefinition> descriptions;

        private State() {
        }
    }
}

