/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.smila.processing.designer.model.processor.ProcessorFactory;
import org.eclipse.smila.processing.designer.model.processor.ProcessorPackage;
import org.eclipse.smila.processing.designer.model.record.RecordPackage;
import org.eclipse.smila.processing.designer.ui.factories.UIAdapterFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SMILADesignerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.smila.processing.designer.ui";
    private static SMILADesignerPlugin plugin;

    public static SMILADesignerPlugin getDefault() {
        return plugin;
    }

    public static void logError(String message, Throwable error) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, error));
    }

    public SMILADesignerPlugin() {
        BPELUtil.registerAdapterFactory((EPackage)ProcessorPackage.eINSTANCE, (AdapterFactory)UIAdapterFactory.getInstance());
        BPELUtil.registerAdapterFactory((EPackage)RecordPackage.eINSTANCE, (AdapterFactory)UIAdapterFactory.getInstance());
        ProcessorFactory.eINSTANCE.getClass();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        URL baseURL = this.getBundle().getEntry("/");
        this.createImageDescriptor(reg, baseURL, "obj16/invokePipelet.png");
        this.createImageDescriptor(reg, baseURL, "obj20/invokePipelet.png");
        this.createImageDescriptor(reg, baseURL, "obj16/icon_map.png");
        this.createImageDescriptor(reg, baseURL, "obj16/icon_seq.png");
        this.createImageDescriptor(reg, baseURL, "obj16/icon_val.png");
    }

    private void createImageDescriptor(ImageRegistry reg, URL baseURL, String id) {
        try {
            reg.put(id, ImageDescriptor.createFromURL((URL)new URL(baseURL, "icons/" + id)));
        }
        catch (MalformedURLException e) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getLocalizedMessage()));
        }
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return this.getImageRegistry().getDescriptor(id);
    }
}

