/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.ui.controls;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditableComboBoxCellEditor
extends CellEditor {
    private int activationStyle = 0;
    private String[] items;
    private String selection;
    private CCombo comboBox;

    public EditableComboBoxCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public EditableComboBoxCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        this.setItems(items);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        this.items = items;
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.populateComboBoxItems();
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                EditableComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                EditableComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                EditableComboBoxCellEditor.this.selection = EditableComboBoxCellEditor.this.comboBox.getText();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                EditableComboBoxCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        return this.selection;
    }

    protected void doSetValue(Object value) {
        this.selection = (String)value;
        this.comboBox.setText(this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.setItems(this.items);
            this.setValueValid(true);
            this.selection = this.comboBox.getText();
        }
    }

    protected void applyEditorValueAndDeactivate() {
        String newValue = this.comboBox.getText();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue));
        } else {
            this.selection = newValue;
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 27) {
            this.fireCancelEditor();
            keyEvent.doit = false;
        } else if (keyEvent.keyCode == 9) {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.keyCode == 127) {
            if ((this.comboBox.getStyle() & 8) == 0) {
                String text;
                Point selection = this.comboBox.getSelection();
                int start = selection.x;
                int end = selection.y;
                if (start == end) {
                    ++end;
                }
                if (end <= (text = this.comboBox.getText()).length()) {
                    this.comboBox.setText(String.valueOf(text.substring(0, start)) + text.substring(end));
                    this.comboBox.setSelection(new Point(start, start));
                }
            }
            keyEvent.doit = false;
        }
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        super.activate(activationEvent);
        if (this.activationStyle != 0) {
            boolean dropDown = false;
            if ((activationEvent.eventType == 2 || activationEvent.eventType == 3) && (this.activationStyle & 1) != 0) {
                dropDown = true;
            } else if (activationEvent.eventType == 1 && (this.activationStyle & 2) != 0) {
                dropDown = true;
            } else if (activationEvent.eventType == 4 && (this.activationStyle & 4) != 0) {
                dropDown = true;
            } else if (activationEvent.eventType == 5 && (this.activationStyle & 8) != 0) {
                dropDown = true;
            }
            if (dropDown) {
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((CCombo)EditableComboBoxCellEditor.this.getControl()).setListVisible(true);
                    }
                });
            }
        }
    }

    public void setActivationStyle(int activationStyle) {
        this.activationStyle = activationStyle;
    }
}

