/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.ui.properties;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.smila.designer.pipelets.KeyDescription;
import org.eclipse.smila.designer.pipelets.MapDescription;
import org.eclipse.smila.designer.pipelets.PipeletDefinition;
import org.eclipse.smila.designer.pipelets.PipeletRegistry;
import org.eclipse.smila.designer.pipelets.RecordDescription;
import org.eclipse.smila.designer.pipelets.SeqDescription;
import org.eclipse.smila.designer.pipelets.ValueDescription;
import org.eclipse.smila.processing.designer.model.processor.Configuration;
import org.eclipse.smila.processing.designer.model.processor.InvokePipelet;
import org.eclipse.smila.processing.designer.model.record.RecordAny;
import org.eclipse.smila.processing.designer.model.record.RecordFactory;
import org.eclipse.smila.processing.designer.model.record.RecordMap;
import org.eclipse.smila.processing.designer.model.record.RecordPackage;
import org.eclipse.smila.processing.designer.model.record.RecordSeq;
import org.eclipse.smila.processing.designer.model.record.RecordVal;
import org.eclipse.smila.processing.designer.model.record.RecordValues;
import org.eclipse.smila.processing.designer.ui.Messages;
import org.eclipse.smila.processing.designer.ui.SMILADesignerPlugin;
import org.eclipse.smila.processing.designer.ui.commands.AddToListFeatureCommand;
import org.eclipse.smila.processing.designer.ui.commands.RemoveFromListFeatureCommand;
import org.eclipse.smila.processing.designer.ui.controls.EditableComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.wsdl.WSDLElement;

public class PipeletConfigurationSection
extends BPELPropertySection {
    private Composite compositeTree;
    private TreeViewer treeViewer;
    private MapDescription pipeletConfiguration;
    private EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getEventType() != 8) {
                PipeletConfigurationSection.this.treeViewer.setInput((Object)PipeletConfigurationSection.this.getInput());
            }
        }
    };

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            public void notify(Notification n) {
                PipeletConfigurationSection.this.treeViewer.setInput((Object)PipeletConfigurationSection.this.getInput());
            }
        }};
    }

    protected void addAllAdapters() {
        super.addAllAdapters();
        Configuration configuration = (Configuration)this.getInput();
        if (configuration != null) {
            configuration.eAdapters().add((Object)this.adapter);
        }
    }

    protected void removeAllAdapters() {
        Configuration configuration = (Configuration)this.getInput();
        if (configuration != null) {
            configuration.eAdapters().remove((Object)this.adapter);
        }
        super.removeAllAdapters();
    }

    protected void basicSetInput(EObject newInput) {
        this.pipeletConfiguration = null;
        InvokePipelet pipelet = (InvokePipelet)newInput;
        if (pipelet == null || pipelet.getConfiguration() == null) {
            super.basicSetInput(null);
        } else {
            PipeletDefinition registeredPipelet;
            super.basicSetInput((EObject)pipelet.getConfiguration());
            if (pipelet.getPipelet() != null && (registeredPipelet = (PipeletDefinition)PipeletRegistry.INSTANCE.getPipelets(this.getBPELFile().getProject()).get(pipelet.getPipelet().getClass_())) != null) {
                this.pipeletConfiguration = registeredPipelet.getParameterDescription();
            }
            this.treeViewer.setInput((Object)pipelet.getConfiguration());
        }
    }

    public void restoreUserContext(Object userContext) {
        this.treeViewer.getTree().setFocus();
    }

    protected void createClient(Composite parent) {
        this.createComponents(parent);
    }

    private Configuration getConfiguration() {
        return (Configuration)this.getInput();
    }

    private void createComponents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpel.ui.PipeletConfigurationSection");
        parent.setLayout((Layout)new GridLayout(1, false));
        this.compositeTree = new Composite(parent, 0);
        this.compositeTree.setLayout((Layout)new GridLayout(1, false));
        this.compositeTree.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer(this.compositeTree, 65536);
        this.treeViewer.setContentProvider((IContentProvider)new TreeViewerContentProvider());
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setAutoExpandLevel(3);
        TreeViewerColumn treeViewerColumnKey = new TreeViewerColumn(this.treeViewer, 0);
        treeViewerColumnKey.getColumn().setText(Messages.PipeletConfigurationSection_KeyColumn);
        treeViewerColumnKey.getColumn().setWidth(200);
        treeViewerColumnKey.setLabelProvider((CellLabelProvider)new ColumnLabelProviderColKey());
        treeViewerColumnKey.setEditingSupport((EditingSupport)new EditingSupportColKey(this.treeViewer));
        TreeViewerColumn treeViewerColumnValue = new TreeViewerColumn(this.treeViewer, 0);
        treeViewerColumnValue.getColumn().setText(Messages.PipeletConfigurationSection_ValueColumn);
        treeViewerColumnValue.getColumn().setWidth(200);
        treeViewerColumnValue.setLabelProvider((CellLabelProvider)new ColumnLabelProviderColValue());
        treeViewerColumnValue.setEditingSupport((EditingSupport)new EditingSupportColValue(this.treeViewer));
        TreeViewerColumn treeViewerColumnType = new TreeViewerColumn(this.treeViewer, 0);
        treeViewerColumnType.getColumn().setText(Messages.PipeletConfigurationSection_TypeColumn);
        treeViewerColumnType.getColumn().setWidth(200);
        treeViewerColumnType.setLabelProvider((CellLabelProvider)new ColumnLabelProviderColType());
        treeViewerColumnType.setEditingSupport((EditingSupport)new EditingSupportColType(this.treeViewer));
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (ColumnViewerEditorActivationStrategy)new TreeViewerColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer), (int)32);
        Menu menuTree = new Menu((Control)parent);
        MenuItem menuItemAddMap = new MenuItem(menuTree, 8);
        menuItemAddMap.setText(Messages.PipeletConfigurationSection_AddMapAction);
        menuItemAddMap.setImage(SMILADesignerPlugin.getDefault().getImageDescriptor("obj16/icon_map.png").createImage());
        menuItemAddMap.addSelectionListener((SelectionListener)new CreateValueMenuAction(RecordPackage.eINSTANCE.getRecordMap()));
        MenuItem menuItemAddSeq = new MenuItem(menuTree, 8);
        menuItemAddSeq.setText(Messages.PipeletConfigurationSection_AddSequenceAction);
        menuItemAddSeq.setImage(SMILADesignerPlugin.getDefault().getImageDescriptor("obj16/icon_seq.png").createImage());
        menuItemAddSeq.addSelectionListener((SelectionListener)new CreateValueMenuAction(RecordPackage.eINSTANCE.getRecordSeq()));
        MenuItem menuItemAddVal = new MenuItem(menuTree, 8);
        menuItemAddVal.setText(Messages.PipeletConfigurationSection_AddValueAction);
        menuItemAddVal.setImage(SMILADesignerPlugin.getDefault().getImageDescriptor("obj16/icon_val.png").createImage());
        menuItemAddVal.addSelectionListener((SelectionListener)new CreateValueMenuAction(RecordPackage.eINSTANCE.getRecordVal()));
        final MenuItem menuItemDelete = new MenuItem(menuTree, 8);
        menuItemDelete.setText(Messages.PipeletConfigurationSection_DeleteAction);
        menuItemDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PipeletConfigurationSection.this.treeViewer.getTree().getSelectionCount() > 0) {
                    PipeletConfigurationSection.this.getCommandFramework().execute(PipeletConfigurationSection.this.wrapInShowContextCommand((Command)new RemoveFromListFeatureCommand((EObject)((RecordAny)PipeletConfigurationSection.this.treeViewer.getTree().getSelection()[0].getData()))));
                }
            }
        });
        this.treeViewer.getTree().setMenu(menuTree);
        this.treeViewer.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                TreeItem treeItem = PipeletConfigurationSection.this.treeViewer.getTree().getItem(PipeletConfigurationSection.this.treeViewer.getTree().toControl(e.x, e.y));
                if (treeItem != null) {
                    PipeletConfigurationSection.this.treeViewer.getTree().select(treeItem);
                } else {
                    PipeletConfigurationSection.this.treeViewer.getTree().deselectAll();
                }
                menuItemDelete.setEnabled(treeItem != null);
            }
        });
    }

    private RecordDescription findDescription(WSDLElement element) {
        if (!(element instanceof RecordAny)) {
            return null;
        }
        if (element instanceof Configuration) {
            return this.pipeletConfiguration;
        }
        WSDLElement container = element.getContainer();
        RecordDescription containerDescription = this.findDescription(container);
        if (containerDescription != null) {
            RecordAny any = (RecordAny)element;
            if (containerDescription instanceof MapDescription) {
                if (any.getKey() != null) {
                    KeyDescription key = (KeyDescription)((MapDescription)containerDescription).getKeys().get(any.getKey());
                    return key == null ? null : key.getValueDescription();
                }
            } else if (containerDescription instanceof SeqDescription && container instanceof RecordSeq) {
                return ((SeqDescription)containerDescription).getElementDescription();
            }
        }
        return null;
    }

    private class ColumnLabelProviderColKey
    extends ColumnLabelProvider {
        private ColumnLabelProviderColKey() {
        }

        public Image getImage(Object element) {
            if (element instanceof RecordMap) {
                return SMILADesignerPlugin.getDefault().getImageDescriptor("obj16/icon_map.png").createImage();
            }
            if (element instanceof RecordSeq) {
                return SMILADesignerPlugin.getDefault().getImageDescriptor("obj16/icon_seq.png").createImage();
            }
            if (element instanceof RecordVal) {
                return SMILADesignerPlugin.getDefault().getImageDescriptor("obj16/icon_val.png").createImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof RecordAny) {
                return ((RecordAny)element).getKey();
            }
            return null;
        }
    }

    private class ColumnLabelProviderColType
    extends ColumnLabelProvider {
        private ColumnLabelProviderColType() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (((RecordAny)element).isVal()) {
                RecordVal recordVal = (RecordVal)element;
                if (recordVal.getType() != null) {
                    return recordVal.getType().label;
                }
                return RecordVal.Type.STRING.label;
            }
            return null;
        }
    }

    private class ColumnLabelProviderColValue
    extends ColumnLabelProvider {
        private ColumnLabelProviderColValue() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof RecordVal) {
                RecordVal recordVal = (RecordVal)element;
                return recordVal != null && recordVal.getValue() != null ? recordVal.getType().format(recordVal.getValue(), Locale.getDefault()) : "";
            }
            return null;
        }
    }

    private final class CreateValueMenuAction
    extends SelectionAdapter {
        private final EClass valueClass;

        public CreateValueMenuAction(EClass valueClass) {
            this.valueClass = valueClass;
        }

        public void widgetSelected(SelectionEvent e) {
            RecordAny value;
            TreeItem treeItem;
            TreeItem treeItem2 = treeItem = PipeletConfigurationSection.this.treeViewer.getTree().getSelectionCount() > 0 ? PipeletConfigurationSection.this.treeViewer.getTree().getSelection()[0] : null;
            Object parent = treeItem == null ? PipeletConfigurationSection.this.getConfiguration() : ((value = (RecordAny)treeItem.getData()).isVal() ? (RecordValues)value.getContainer() : (RecordValues)value);
            RecordAny newValue = (RecordAny)RecordFactory.eINSTANCE.create(this.valueClass);
            if (parent.isMap()) {
                newValue.setKey(Messages.PipeletConfigurationSection_DefaultKey);
            }
            PipeletConfigurationSection.this.getCommandFramework().execute(PipeletConfigurationSection.this.wrapInShowContextCommand((Command)new AddToListFeatureCommand((EObject)parent, newValue, (EStructuralFeature)RecordPackage.eINSTANCE.getRecordValues_Values())));
        }
    }

    private class EditingSupportColKey
    extends EditingSupport {
        private EditableComboBoxCellEditor editor;

        private EditingSupportColKey(TreeViewer viewer) {
            super((ColumnViewer)viewer);
            this.editor = new EditableComboBoxCellEditor((Composite)viewer.getTree(), new String[0]);
        }

        protected boolean canEdit(Object element) {
            return element instanceof RecordAny && ((RecordAny)element).getContainer() instanceof RecordMap;
        }

        protected CellEditor getCellEditor(Object element) {
            RecordMap map = (RecordMap)((RecordAny)element).getContainer();
            RecordDescription containerDescription = PipeletConfigurationSection.this.findDescription((WSDLElement)map);
            if (containerDescription instanceof MapDescription) {
                HashSet keys = new HashSet(((MapDescription)containerDescription).getKeys().keySet());
                for (RecordAny value : map.getValues()) {
                    if (value == element) continue;
                    keys.remove(value.getKey());
                }
                Object[] result = keys.toArray(new String[keys.size()]);
                Arrays.sort(result);
                this.editor.setItems((String[])result);
            } else {
                this.editor.setItems(new String[0]);
            }
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RecordAny) {
                String o = ((RecordAny)element).getKey();
                return o != null ? o : "";
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            PipeletConfigurationSection.this.getCommandFramework().execute(PipeletConfigurationSection.this.wrapInShowContextCommand((Command)new SetCommand((EObject)((RecordAny)element), value, (EStructuralFeature)RecordPackage.eINSTANCE.getRecordAny_Key())));
        }
    }

    private class EditingSupportColType
    extends EditingSupport {
        private final ComboBoxCellEditor editor;

        public EditingSupportColType(TreeViewer viewer) {
            super((ColumnViewer)viewer);
            ArrayList<String> items = new ArrayList<String>();
            RecordVal.Type[] typeArray = RecordVal.Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RecordVal.Type type = typeArray[n2];
                items.add(type.label);
                ++n2;
            }
            this.editor = new ComboBoxCellEditor((Composite)viewer.getTree(), items.toArray(new String[items.size()]), 8);
            ((CCombo)this.editor.getControl()).addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EditingSupportColType.this.editor.deactivate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        protected boolean canEdit(Object element) {
            return element instanceof RecordVal;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element != null && ((RecordAny)element).isVal()) {
                RecordVal recordVal = (RecordVal)element;
                if (recordVal.getType() != null) {
                    return recordVal.getType().ordinal();
                }
                return RecordVal.Type.STRING.ordinal();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            RecordVal recordVal = (RecordVal)element;
            RecordVal.Type newType = RecordVal.Type.values()[(Integer)value];
            try {
                Object newValue;
                if (recordVal.getValue() == null || "".equals(recordVal.getValue()) || "0".equals(recordVal.getValue())) {
                    switch (newType) {
                        case BOOLEAN: {
                            newValue = Boolean.FALSE;
                            break;
                        }
                        case DATE: {
                            newValue = new Date(System.currentTimeMillis());
                            break;
                        }
                        case DATETIME: {
                            newValue = new Timestamp(System.currentTimeMillis());
                            break;
                        }
                        case DOUBLE: {
                            newValue = new Double(0.0);
                            break;
                        }
                        case LONG: {
                            newValue = new Long(0L);
                            break;
                        }
                        default: {
                            newValue = "";
                            break;
                        }
                    }
                } else {
                    newValue = newType.parse(recordVal.getType().format(recordVal.getValue()));
                }
                PipeletConfigurationSection.this.getCommandFramework().execute(PipeletConfigurationSection.this.wrapInShowContextCommand((Command)new SetCommand((EObject)recordVal, newValue, (EStructuralFeature)RecordPackage.eINSTANCE.getRecordVal_Value())));
            }
            catch (ParseException parseException) {
                MessageDialog.openError((Shell)PipeletConfigurationSection.this.compositeTree.getShell(), (String)Messages.PipeletConfigurationSection_ParseErrorTitle, (String)MessageFormat.format(Messages.PipeletConfigurationSection_ParseErrorMessage, recordVal.getValue().toString(), newType.label));
            }
        }
    }

    private class EditingSupportColValue
    extends EditingSupport {
        private TextCellEditor textEditor;
        private EditableComboBoxCellEditor comboBoxEditor;

        private EditingSupportColValue(TreeViewer viewer) {
            super((ColumnViewer)viewer);
            this.textEditor = new TextCellEditor((Composite)viewer.getTree());
            this.comboBoxEditor = new EditableComboBoxCellEditor((Composite)viewer.getTree(), new String[0]);
        }

        protected CellEditor getCellEditor(Object element) {
            ValueDescription value;
            RecordDescription description = PipeletConfigurationSection.this.findDescription((WSDLElement)((RecordAny)element));
            if (description != null && description instanceof ValueDescription && !(value = (ValueDescription)description).getItems().isEmpty()) {
                Object[] result = value.getItems().keySet().toArray(new String[value.getItems().size()]);
                Arrays.sort(result);
                this.comboBoxEditor.setItems((String[])result);
                return this.comboBoxEditor;
            }
            return this.textEditor;
        }

        protected boolean canEdit(Object element) {
            return element instanceof RecordVal;
        }

        protected Object getValue(Object element) {
            RecordVal recordVal;
            if (element instanceof RecordVal && (recordVal = (RecordVal)element).getValue() != null) {
                return recordVal.getType().format(recordVal.getValue(), Locale.getDefault());
            }
            return "";
        }

        protected void setValue(Object element, Object value) {
            RecordVal recordVal = (RecordVal)element;
            RecordVal.Type type = recordVal.getType() != null ? recordVal.getType() : RecordVal.Type.STRING;
            try {
                value = type.parse(value.toString(), Locale.getDefault());
                PipeletConfigurationSection.this.getCommandFramework().execute(PipeletConfigurationSection.this.wrapInShowContextCommand((Command)new SetCommand((EObject)recordVal, value, (EStructuralFeature)RecordPackage.eINSTANCE.getRecordVal_Value())));
            }
            catch (ParseException parseException) {
                MessageDialog.openError((Shell)PipeletConfigurationSection.this.compositeTree.getShell(), (String)Messages.PipeletConfigurationSection_ParseErrorTitle, (String)MessageFormat.format(Messages.PipeletConfigurationSection_ParseErrorMessage, value.toString(), type.label));
            }
        }
    }

    private class TreeViewerColumnViewerEditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        public TreeViewerColumnViewerEditorActivationStrategy(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            boolean isLeftMouseDoubleSelect;
            MouseEvent mouseEvent = (MouseEvent)event.sourceEvent;
            boolean singleSelect = ((IStructuredSelection)PipeletConfigurationSection.this.treeViewer.getSelection()).size() == 1;
            boolean bl = isLeftMouseDoubleSelect = event.eventType == 3 && mouseEvent.button == 1;
            return singleSelect && (isLeftMouseDoubleSelect || event.eventType == 4 || event.eventType == 5 || event.eventType == 1 && event.keyCode == 13);
        }
    }

    private class TreeViewerContentProvider
    implements ITreeContentProvider {
        private TreeViewerContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement != null) {
                if (parentElement instanceof RecordValues) {
                    return ((RecordValues)parentElement).getValues().toArray();
                }
                return new Object[0];
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof RecordAny && !(element instanceof Configuration)) {
                return ((RecordAny)element).getContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }
}

