/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.common.ui.details.widgets.DecoratedLabel;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.smila.designer.pipelets.PipeletDefinition;
import org.eclipse.smila.designer.pipelets.PipeletRegistry;
import org.eclipse.smila.processing.designer.model.processor.Pipelet;
import org.eclipse.smila.processing.designer.model.processor.ProcessorPackage;
import org.eclipse.smila.processing.designer.ui.Messages;
import org.eclipse.smila.processing.designer.ui.adapters.InvokePipeletAdapter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class PipeletTypeSection
extends BPELPropertySection {
    private CCombo typeField;
    private Text descriptionField;
    private EditController typeEditController;
    private InvokePipeletAdapter pipeletAdapter;

    protected void basicSetInput(EObject input) {
        super.basicSetInput(input);
        this.pipeletAdapter = (InvokePipeletAdapter)((Object)BPELUtil.adapt((Object)input, InvokePipeletAdapter.class));
        this.typeEditController.setInput(input);
    }

    protected void createClient(Composite parent) {
        this.createComponents(parent);
        this.createChangeTrackers();
    }

    private void createComponents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpel.ui.PipeletTypeSection");
        Composite composite = this.createFlatFormComposite(parent);
        DecoratedLabel typeLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)typeLabel);
        typeLabel.setText(Messages.PipeletTypeSection_TypeLabel);
        this.typeField = this.fWidgetFactory.createCCombo(composite, 0x800000);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)typeLabel, (int)131));
        data.right = new FlatFormAttachment(100, -10);
        data.top = new FlatFormAttachment(0, 4);
        this.typeField.setLayoutData((Object)data);
        ArrayList<String> classNames = new ArrayList<String>();
        for (PipeletDefinition pipelet : PipeletRegistry.INSTANCE.getPipelets(this.getBPELFile().getProject()).values()) {
            classNames.add(pipelet.getClassName());
        }
        Collections.sort(classNames);
        this.typeField.setItems(classNames.toArray(new String[classNames.size()]));
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.typeField, -5);
        data.top = new FlatFormAttachment((Control)this.typeField, 0, 0x1000000);
        typeLabel.setLayoutData((Object)data);
        DecoratedLabel descriptionLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)descriptionLabel);
        descriptionLabel.setText(Messages.PipeletTypeSection_DescriptionLabel);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment((Control)this.typeField, 5, 1024);
        descriptionLabel.setLayoutData((Object)data);
        this.descriptionField = this.fWidgetFactory.createText(composite, "", 74);
        data = new FlatFormData();
        data.width = 100;
        data.height = 50;
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.typeField, 0, 131072);
        data.top = new FlatFormAttachment((Control)descriptionLabel, 0, 1024);
        data.bottom = new FlatFormAttachment(100, -4);
        this.descriptionField.setLayoutData((Object)data);
    }

    private void updateDescriptionField() {
        String className = this.typeField.getText();
        PipeletDefinition pipelet = (PipeletDefinition)PipeletRegistry.INSTANCE.getPipelets(this.getBPELFile().getProject()).get(className);
        this.descriptionField.setText(pipelet == null ? "" : pipelet.getDescription());
    }

    private void createChangeTrackers() {
        this.typeEditController = new EditController(this.getCommandFramework()){

            public boolean checkNotification(Notification notification) {
                return notification.getFeatureID(Pipelet.class) == 4;
            }

            public Command createApplyCommand() {
                return PipeletTypeSection.this.wrapInShowContextCommand(super.createApplyCommand());
            }

            public void handleEvent(Event event) {
                super.handleEvent(event);
                switch (event.type) {
                    case 13: 
                    case 14: 
                    case 24: {
                        PipeletTypeSection.this.updateDescriptionField();
                    }
                }
            }
        };
        this.typeEditController.setLabel(ProcessorPackage.eINSTANCE.getPipelet_Class().getName());
        this.typeEditController.setViewIValue(new IValue(){

            public Object get() {
                return PipeletTypeSection.this.typeField.getText();
            }

            public void set(Object text) {
                if (text == null) {
                    PipeletTypeSection.this.typeField.setText("");
                } else {
                    String className = text.toString();
                    PipeletTypeSection.this.typeField.setText(className);
                }
                PipeletTypeSection.this.updateDescriptionField();
            }
        });
        this.typeEditController.setModeIValue(new IValue(){

            public Object get() {
                return PipeletTypeSection.this.pipeletAdapter != null ? PipeletTypeSection.this.pipeletAdapter.getClassName(PipeletTypeSection.this.typeEditController.getInput()) : null;
            }

            public void set(Object object) {
                if (PipeletTypeSection.this.pipeletAdapter != null) {
                    PipeletTypeSection.this.pipeletAdapter.setClassName(PipeletTypeSection.this.typeEditController.getInput(), object.toString());
                }
            }
        });
        this.typeEditController.startListeningTo(new Control[]{this.typeField});
    }

    public void restoreUserContext(Object userContext) {
        this.typeField.setFocus();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

