/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.designer.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.common.ui.details.widgets.DecoratedLabel;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smila.processing.designer.model.processor.InvokePipelet;
import org.eclipse.smila.processing.designer.model.processor.ProcessorPackage;
import org.eclipse.smila.processing.designer.model.processor.Variables;
import org.eclipse.smila.processing.designer.ui.Messages;
import org.eclipse.smila.processing.designer.ui.SMILADesignerPlugin;
import org.eclipse.smila.processing.designer.ui.properties.CComboIValue;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class PipeletVariablesSection
extends BPELPropertySection {
    private CCombo inputField;
    private CCombo outputField;
    private CCombo indexField;
    private List<EditController> controllers = new ArrayList<EditController>();

    protected void basicSetInput(EObject input) {
        Variables variables;
        super.basicSetInput(input);
        ArrayList<String> variablesNames = new ArrayList<String>();
        Variable[] variableArray = BPELUtil.getVisibleVariables((EObject)input);
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variablesNames.add(variable.getName());
            ++n2;
        }
        String[] items = variablesNames.toArray(new String[variablesNames.size()]);
        this.inputField.setItems(items);
        this.outputField.setItems(items);
        this.indexField.setItems(items);
        if (input instanceof Variables) {
            variables = (Variables)input;
        } else if (input instanceof InvokePipelet) {
            variables = ((InvokePipelet)input).getVariables();
        } else {
            SMILADesignerPlugin.logError("Unknown type of input: " + input, null);
            variables = null;
        }
        for (EditController controller : this.controllers) {
            controller.setInput((EObject)variables);
        }
    }

    protected void createClient(Composite parent) {
        this.createComponents(parent);
        this.createChangeTrackers();
    }

    private void createComponents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpel.ui.PipeletVariablesSection");
        Composite composite = this.createFlatFormComposite(parent);
        DecoratedLabel inputLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)inputLabel);
        inputLabel.setText(Messages.PipeletVariablesSection_InputLabel);
        this.inputField = this.fWidgetFactory.createCCombo(composite, 0x800000);
        this.applyLayout(null, (Control)inputLabel, new Control[]{this.inputField});
        DecoratedLabel outputLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)outputLabel);
        outputLabel.setText(Messages.PipeletVariablesSection_OutputLabel);
        this.outputField = this.fWidgetFactory.createCCombo(composite, 0x800000);
        this.applyLayout((Control)this.inputField, (Control)outputLabel, new Control[]{this.outputField, this.fWidgetFactory.createLabel(composite, Messages.PipeletVariablesSection_OutputRemark)});
        DecoratedLabel indexLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)indexLabel);
        indexLabel.setText(Messages.PipeletVariablesSection_IndexLabel);
        this.indexField = this.fWidgetFactory.createCCombo(composite, 0x800000);
        this.applyLayout((Control)this.outputField, (Control)indexLabel, new Control[]{this.indexField, this.fWidgetFactory.createLabel(composite, Messages.PipeletVariablesSection_IndexRemark)});
    }

    private void applyLayout(Control previous, Control label, Control ... controls) {
        int i = 0;
        while (i < controls.length) {
            FlatFormData data = new FlatFormData();
            if (i == 0) {
                data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)label, (int)105));
            }
            data.right = i == controls.length - 1 ? new FlatFormAttachment(100, -10) : new FlatFormAttachment(controls[i + 1], -5);
            if (i == 0) {
                data.top = previous != null ? new FlatFormAttachment(previous, 4, 1024) : new FlatFormAttachment(0, 4);
            } else {
                data.bottom = new FlatFormAttachment(controls[i - 1], 0, 0x1000000);
            }
            controls[i].setLayoutData((Object)data);
            ++i;
        }
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(controls[0], -5);
        data.top = new FlatFormAttachment(controls[0], 0, 0x1000000);
        label.setLayoutData((Object)data);
    }

    private void createChangeTrackers() {
        EditController inputController = new EditController(this.getCommandFramework());
        inputController.setFeature((EStructuralFeature)ProcessorPackage.eINSTANCE.getVariables_Input());
        inputController.setViewIValue((IValue)new CComboIValue(this.inputField));
        inputController.startListeningTo(new Control[]{this.inputField});
        this.controllers.add(inputController);
        EditController outputController = new EditController(this.getCommandFramework());
        outputController.setFeature((EStructuralFeature)ProcessorPackage.eINSTANCE.getVariables_Output());
        outputController.setViewIValue((IValue)new CComboIValue(this.outputField));
        outputController.startListeningTo(new Control[]{this.outputField});
        this.controllers.add(outputController);
        EditController indexController = new EditController(this.getCommandFramework());
        indexController.setFeature((EStructuralFeature)ProcessorPackage.eINSTANCE.getVariables_Index());
        indexController.setViewIValue((IValue)new CComboIValue(this.indexField));
        indexController.startListeningTo(new Control[]{this.indexField});
        this.controllers.add(indexController);
    }

    public void restoreUserContext(Object userContext) {
        this.inputField.setFocus();
    }
}

