/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.parameters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.processing.parameters.SearchParameters;

public class ParameterAccessor {
    private Blackboard _blackboard;
    private Id _query;
    private Id _record;
    private PipeletConfiguration _config;
    private LinkedHashMap<String, SearchParameters.OrderMode> _orderByCache;

    public ParameterAccessor(Blackboard blackboard) {
        this._blackboard = blackboard;
    }

    public ParameterAccessor(Blackboard blackboard, Id query) {
        this(blackboard);
        this._query = query;
    }

    public ParameterAccessor setCurrentRecord(Id currentRecord) {
        this._record = currentRecord;
        this._orderByCache = null;
        return this;
    }

    public ParameterAccessor setPipeletConfiguration(PipeletConfiguration config) {
        this._config = config;
        this._orderByCache = null;
        return this;
    }

    public String getQuery() {
        return this.getParameter("query", null);
    }

    public int getResultSize() {
        return this.getIntParameter("resultSize", 10);
    }

    public int getResultOffset() {
        return this.getIntParameter("resultOffset", 0);
    }

    public double getThreshold() {
        return this.getFloatParameter("threshold", 0.0);
    }

    public String getLanguage() {
        return this.getParameter("language", null);
    }

    public String getIndexName() {
        return this.getParameter("indexName", null);
    }

    public List<String> getResultAttributes() {
        List<String> values = this.getParameters("resultAttributes");
        if (values == null || values.isEmpty()) {
            values = new ArrayList<String>();
            String value = this.getParameter("resultAttributes", null);
            if (value != null) {
                values.add(value);
            }
        }
        return values;
    }

    public Iterator<String> getOrderByAttributeNames() {
        if (this._orderByCache == null) {
            this.createOrderByCache();
        }
        return this._orderByCache.keySet().iterator();
    }

    public SearchParameters.OrderMode getOrderMode(String attributeName) {
        if (this._orderByCache == null) {
            this.createOrderByCache();
        }
        return this._orderByCache.get(attributeName);
    }

    public String getParameter(String name, String defaultValue) {
        Object property;
        String value = null;
        if (this._record != null) {
            value = this.getRecordParameter(name, this._record);
        }
        if (value == null && this._query != null) {
            value = this.getRecordParameter(name, this._query);
        }
        if (value == null && this._config != null && (property = this._config.getPropertyFirstValue(name)) != null) {
            value = property.toString();
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getRequiredParameter(String name) throws MissingParameterException {
        String value = this.getParameter(name, null);
        if (value == null) {
            throw new MissingParameterException("no single value for required parameter " + name);
        }
        return value;
    }

    public List<String> getParameters(String name) {
        String[] propValues;
        List<String> values = null;
        if (this._record != null) {
            values = this.getRecordParameters(name, this._record);
        }
        if (values == null && this._query != null) {
            values = this.getRecordParameters(name, this._query);
        }
        if (values == null && this._config != null && (propValues = this._config.getPropertyStringValues(name)) != null && propValues.length > 0) {
            values = Arrays.asList(propValues);
        }
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        return values;
    }

    public List<String> getRequiredParameters(String name) throws MissingParameterException {
        List<String> values = this.getParameters(name);
        if (values == null || values.isEmpty()) {
            throw new MissingParameterException("no list value for required parameter " + name);
        }
        return values;
    }

    public Integer getIntParameter(String name, Integer defaultValue) {
        String value = this.getParameter(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public Double getFloatParameter(String name, Double defaultValue) {
        String value = this.getParameter(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Double.valueOf(value);
    }

    public Boolean getBooleanParameter(String name, Boolean defaultValue) {
        String value = this.getParameter(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public Integer getRequiredIntParameter(String name) throws MissingParameterException {
        String value = this.getRequiredParameter(name);
        return Integer.valueOf(value);
    }

    public Double getRequiredFloatParameter(String name) throws MissingParameterException {
        String value = this.getRequiredParameter(name);
        return Double.valueOf(value);
    }

    public Boolean getRequiredBooleanParameter(String name) throws MissingParameterException {
        String value = this.getRequiredParameter(name);
        return Boolean.valueOf(value);
    }

    public Annotation getAnnotation(String name) {
        List<Annotation> annotations = this.getAnnotations(name);
        if (annotations == null || annotations.isEmpty()) {
            return null;
        }
        return annotations.get(0);
    }

    public List<Annotation> getAnnotations(String name) {
        List<Annotation> annotations = null;
        if (this._record != null) {
            annotations = this.getRecordSubAnnotations(name, this._record);
        }
        if (annotations == null && this._query != null) {
            annotations = this.getRecordSubAnnotations(name, this._query);
        }
        if (annotations == null) {
            return Collections.EMPTY_LIST;
        }
        return annotations;
    }

    private void createOrderByCache() {
        this._orderByCache = new LinkedHashMap();
        List<Annotation> annotations = this.getAnnotations("orderBy");
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                String attributeName = annotation.getNamedValue("attribute");
                String orderModeValue = annotation.getNamedValue("mode");
                SearchParameters.OrderMode orderMode = SearchParameters.OrderMode.valueOf(orderModeValue);
                if (attributeName == null || orderMode == null) continue;
                this._orderByCache.put(attributeName, orderMode);
            }
        }
    }

    private String getRecordParameter(String name, Id record) {
        try {
            String value;
            Annotation annotation = this._blackboard.getAnnotation(record, null, "parameters");
            if (annotation != null && (value = annotation.getNamedValue(name)) != null) {
                return value;
            }
        }
        catch (Exception exception) {
        }
        return null;
    }

    private List<String> getRecordParameters(String name, Id record) {
        try {
            ArrayList values;
            Annotation annotation = this._blackboard.getAnnotation(record, null, "parameters");
            if (annotation != null && annotation.hasAnnotation(name) && !(values = annotation.getAnnotation(name).getAnonValues()).isEmpty()) {
                if (!(values instanceof List)) {
                    values = new ArrayList(values);
                }
                return values;
            }
        }
        catch (Exception exception) {
        }
        return null;
    }

    private List<Annotation> getRecordSubAnnotations(String name, Id record) {
        try {
            ArrayList subAnnotations;
            Annotation annotation = this._blackboard.getAnnotation(record, null, "parameters");
            if (annotation != null && annotation.hasAnnotation(name) && !(subAnnotations = annotation.getAnnotations(name)).isEmpty()) {
                if (!(subAnnotations instanceof List)) {
                    subAnnotations = new ArrayList(subAnnotations);
                }
                return subAnnotations;
            }
        }
        catch (Exception exception) {
        }
        return null;
    }
}

