/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BrokeredReliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.BrokeredTransactedMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.BrokeredUnreliableMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeCache;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.SharedEndpoints;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.InvocationStyle;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelServerImpl
implements BpelServer,
Scheduler.JobProcessor {
    private static final Log __log = LogFactory.getLog(BpelServerImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private static Long __processMaxAge;
    private Random _random = new Random(System.currentTimeMillis());
    private static double _delayMean;
    private final HashMap<QName, ODEProcess> _registeredProcesses = new HashMap();
    private final HashMap<QName, List<ODEProcess>> _serviceMap = new HashMap();
    private final MyRoleMessageExchangeCache _myRoleMexCache = new MyRoleMessageExchangeCache();
    private State _state = State.SHUTDOWN;
    Contexts _contexts = new Contexts();
    private DehydrationPolicy _dehydrationPolicy;
    private OdeConfigProperties _properties;
    private ExecutorService _exec;
    BpelDatabase _db;
    private ReadWriteLock _mngmtLock = new ReentrantReadWriteLock();
    private final AtomicLong _lastTimeOfServerCallable = new AtomicLong(System.currentTimeMillis());
    private SharedEndpoints _sharedEps;

    protected void waitForQuiessence() {
        long l;
        do {
            this._mngmtLock.writeLock().lock();
            this._mngmtLock.writeLock().unlock();
            l = this._lastTimeOfServerCallable.get();
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._mngmtLock.writeLock().lock();
            this._mngmtLock.writeLock().unlock();
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this._lastTimeOfServerCallable.get() != l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this._mngmtLock.writeLock().lock();
        try {
            Object object;
            if (!this.checkState(State.INIT, State.RUNNING)) {
                __log.debug((Object)"start() ignored -- already started");
                return;
            }
            __log.debug((Object)"BPEL SERVER starting.");
            if (this._exec == null) {
                object = new ThreadFactory(){
                    int threadNumber = 0;

                    public Thread newThread(Runnable runnable) {
                        ++this.threadNumber;
                        Thread thread = new Thread(runnable, "ODEServerImpl-" + this.threadNumber);
                        thread.setDaemon(true);
                        return thread;
                    }
                };
                this._exec = Executors.newCachedThreadPool((ThreadFactory)object);
            }
            if (this._contexts.txManager == null) {
                object = "Transaction manager not specified; call setTransactionManager(...)!";
                __log.fatal(object);
                throw new IllegalStateException((String)object);
            }
            if (this._contexts.scheduler == null) {
                object = "Scheduler not specified; call setScheduler(...)!";
                __log.fatal(object);
                throw new IllegalStateException((String)object);
            }
            this._contexts.scheduler.start();
            this._state = State.RUNNING;
            __log.info((Object)__msgs.msgServerStarted());
            if (this._dehydrationPolicy != null) {
                new Thread(new ProcessDefReaper()).start();
            }
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public void registerExternalVariableEngine(ExternalVariableModule externalVariableModule) {
        this._contexts.externalVariableEngines.put(externalVariableModule.getName(), externalVariableModule);
    }

    public void registerBpelEventListener(BpelEventListener bpelEventListener) {
        bpelEventListener.startup(this._properties.getProperties());
        this._contexts.eventListeners.add(bpelEventListener);
    }

    public void unregisterBpelEventListener(BpelEventListener bpelEventListener) {
        if (this._contexts.eventListeners.remove(bpelEventListener)) {
            try {
                bpelEventListener.shutdown();
            }
            catch (Exception exception) {
                __log.warn((Object)("Stopping BPEL event listener " + bpelEventListener.getClass().getName() + " failed, nevertheless it has been unregistered."), (Throwable)exception);
            }
        }
    }

    private void unregisterBpelEventListeners() {
        for (BpelEventListener bpelEventListener : this._contexts.eventListeners) {
            this.unregisterBpelEventListener(bpelEventListener);
        }
    }

    public void registerExtensionBundle(ExtensionBundleRuntime extensionBundleRuntime) {
        this._contexts.extensionRegistry.put(extensionBundleRuntime.getNamespaceURI(), extensionBundleRuntime);
        extensionBundleRuntime.registerExtensionActivities();
    }

    public void unregisterExtensionBundle(String string) {
        this._contexts.extensionRegistry.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.RUNNING, State.INIT)) {
                __log.debug((Object)"stop() ignored -- already stopped");
                return;
            }
            __log.debug((Object)"BPEL SERVER STOPPING");
            this._contexts.scheduler.stop();
            this._state = State.INIT;
            __log.info((Object)__msgs.msgServerStopped());
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws BpelEngineException {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.SHUTDOWN, State.INIT)) {
                return;
            }
            __log.debug((Object)"BPEL SERVER initializing ");
            this._db = new BpelDatabase(this._contexts);
            this._state = State.INIT;
            this._sharedEps = new SharedEndpoints();
            this._sharedEps.init();
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws BpelEngineException {
        this._mngmtLock.writeLock().lock();
        try {
            this.stop();
            this.unregisterBpelEventListeners();
            this._sharedEps = null;
            this._db = null;
            this._state = State.SHUTDOWN;
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ProcessConf processConf) {
        if (processConf == null) {
            throw new NullPointerException("must specify non-null process configuration.");
        }
        __log.debug((Object)("register: " + processConf.getProcessId()));
        try {
            this._mngmtLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            __log.debug((Object)"register(...) interrupted.", (Throwable)interruptedException);
            throw new BpelEngineException(__msgs.msgOperationInterrupted());
        }
        try {
            if (this._registeredProcesses.containsKey(processConf.getProcessId())) {
                __log.debug((Object)("skipping doRegister" + processConf.getProcessId() + ") -- process is already registered"));
                return;
            }
            __log.debug((Object)("Registering process " + processConf.getProcessId() + " with server."));
            ODEProcess oDEProcess = new ODEProcess(this, processConf, null, this._myRoleMexCache);
            for (Endpoint endpoint : oDEProcess.getServiceNames()) {
                __log.debug((Object)("Register process: serviceId=" + endpoint + ", process=" + oDEProcess));
                List<ODEProcess> list = this._serviceMap.get(endpoint.serviceName);
                if (list == null) {
                    list = new ArrayList<ODEProcess>();
                    this._serviceMap.put(endpoint.serviceName, list);
                }
                for (int i = 0; i < list.size(); ++i) {
                    ODEProcess oDEProcess2 = list.get(i);
                    __log.debug((Object)("cached version " + oDEProcess2.getPID() + " vs registering version " + oDEProcess.getPID()));
                    if (!oDEProcess2.getProcessType().equals(oDEProcess.getProcessType())) continue;
                    list.remove(oDEProcess2);
                }
                list.add(oDEProcess);
            }
            oDEProcess.activate(this._contexts);
            this._registeredProcesses.put(oDEProcess.getPID(), oDEProcess);
            if (this._dehydrationPolicy == null) {
                oDEProcess.hydrate();
            }
            __log.info((Object)__msgs.msgProcessRegistered(processConf.getProcessId()));
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public void unregister(QName qName) throws BpelEngineException {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("unregister: " + qName));
        }
        try {
            this._mngmtLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            __log.debug((Object)"unregister() interrupted.", (Throwable)interruptedException);
            throw new BpelEngineException(__msgs.msgOperationInterrupted());
        }
        try {
            ODEProcess oDEProcess = this._registeredProcesses.remove(qName);
            if (oDEProcess == null) {
                return;
            }
            oDEProcess.deactivate();
            for (List<ODEProcess> list : this._serviceMap.values()) {
                __log.debug((Object)("removing process " + qName + "; handle " + oDEProcess + "; exists " + list.contains(oDEProcess)));
                list.remove(oDEProcess);
            }
            __log.info((Object)__msgs.msgProcessUnregistered(qName));
        }
        catch (Exception exception) {
            __log.error((Object)__msgs.msgProcessUnregisterFailed(qName), (Throwable)exception);
            throw new BpelEngineException((Throwable)exception);
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public void registerMessageExchangeInterceptor(MessageExchangeInterceptor messageExchangeInterceptor) {
        this._contexts.globalIntereceptors.add(messageExchangeInterceptor);
    }

    public void unregisterMessageExchangeInterceptor(MessageExchangeInterceptor messageExchangeInterceptor) {
        this._contexts.globalIntereceptors.remove(messageExchangeInterceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ODEProcess> route(QName qName, Message message) {
        this._mngmtLock.readLock().lock();
        try {
            List<ODEProcess> list = this._serviceMap.get(qName);
            return list;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    private final boolean checkState(State state, State state2) {
        if (this._state == state) {
            return true;
        }
        if (this._state == state2) {
            return false;
        }
        return false;
    }

    private boolean deleteProcessDAO(final QName qName) {
        try {
            return this._db.exec(new BpelDatabase.Callable<Boolean>(){

                @Override
                public Boolean run(BpelDAOConnection bpelDAOConnection) throws Exception {
                    ProcessDAO processDAO = bpelDAOConnection.getProcess(qName);
                    if (processDAO != null) {
                        processDAO.delete();
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            String string = "DbError";
            __log.error((Object)string, (Throwable)exception);
            throw new BpelEngineException(string, (Throwable)exception);
        }
    }

    public void onScheduledJob(final Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
        this._mngmtLock.readLock().lock();
        try {
            final WorkEvent workEvent = new WorkEvent(jobInfo.jobDetail);
            ODEProcess oDEProcess = this._registeredProcesses.get(workEvent.getProcessId());
            if (oDEProcess == null) {
                this._contexts.execTransaction(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        BpelServerImpl.this._contexts.scheduler.jobCompleted(jobInfo.jobName);
                        Date date = new Date(System.currentTimeMillis() + 60000L);
                        __log.info((Object)__msgs.msgReschedulingJobForInactiveProcess(workEvent.getProcessId(), jobInfo.jobName, date));
                        BpelServerImpl.this._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), date);
                        return null;
                    }
                });
                return;
            }
            if (workEvent.getType().equals((Object)WorkEvent.Type.INVOKE_CHECK)) {
                PartnerRoleMessageExchange partnerRoleMessageExchange;
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("handleWorkEvent: InvokeCheck event for mexid " + workEvent.getMexId()));
                }
                if ((partnerRoleMessageExchange = (PartnerRoleMessageExchange)this.getMessageExchange(workEvent.getMexId())).getStatus() == MessageExchange.Status.ASYNC || partnerRoleMessageExchange.getStatus() == MessageExchange.Status.ACK) {
                    String string = "Dangling invocation (mexId=" + workEvent.getMexId() + "), forcing it into a failed state.";
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)string);
                    }
                    partnerRoleMessageExchange.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, string, null);
                }
                return;
            }
            oDEProcess.handleWorkEvent(jobInfo);
        }
        catch (Exception exception) {
            throw new Scheduler.JobProcessorException((Throwable)exception, jobInfo.jobDetail.get("inmem") == null);
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this._contexts.txManager = transactionManager;
    }

    public void setDehydrationPolicy(DehydrationPolicy dehydrationPolicy) {
        this._dehydrationPolicy = dehydrationPolicy;
    }

    public void setConfigProperties(OdeConfigProperties odeConfigProperties) {
        this._properties = odeConfigProperties;
    }

    public OdeConfigProperties getConfigProperties() {
        return this._properties;
    }

    public void setMessageExchangeContext(MessageExchangeContext messageExchangeContext) throws BpelEngineException {
        this._contexts.mexContext = messageExchangeContext;
    }

    public void setScheduler(Scheduler scheduler) throws BpelEngineException {
        this._contexts.scheduler = scheduler;
    }

    public void setEndpointReferenceContext(EndpointReferenceContext endpointReferenceContext) throws BpelEngineException {
        this._contexts.eprContext = endpointReferenceContext;
    }

    public void setDaoConnectionFactory(BpelDAOConnectionFactory bpelDAOConnectionFactory) throws BpelEngineException {
        this._contexts.dao = bpelDAOConnectionFactory;
    }

    public void setBindingContext(BindingContext bindingContext) {
        this._contexts.bindingContext = bindingContext;
    }

    public SharedEndpoints getSharedEndpoints() {
        return this._sharedEps;
    }

    public void setExecutor(ExecutorService executorService) {
        this._exec = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MyRoleMessageExchange createMessageExchange(InvocationStyle invocationStyle, QName qName, String string, String string2) throws BpelEngineException {
        this._mngmtLock.readLock().lock();
        try {
            List<ODEProcess> list = this.route(qName, null);
            if (list == null || list.size() == 0) {
                throw new BpelEngineException("NoSuchService: " + qName);
            }
            if (list.size() == 1) {
                ODEProcess oDEProcess = list.get(0);
                MyRoleMessageExchange myRoleMessageExchange = this.createNewMyRoleMex(oDEProcess, invocationStyle, qName, string, string2);
                return myRoleMessageExchange;
            }
            ArrayList<MyRoleMessageExchange> arrayList = new ArrayList<MyRoleMessageExchange>();
            for (ODEProcess oDEProcess : list) {
                arrayList.add(this.createNewMyRoleMex(oDEProcess, invocationStyle, qName, string, string2));
            }
            MyRoleMessageExchange myRoleMessageExchange = this.createNewMyRoleMex(list.get(0), arrayList, invocationStyle);
            return myRoleMessageExchange;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    private MyRoleMessageExchange createNewMyRoleMex(ODEProcess oDEProcess, InvocationStyle invocationStyle, QName qName, String string, String string2) {
        if (invocationStyle == InvocationStyle.RELIABLE || invocationStyle == InvocationStyle.TRANSACTED) {
            this.assertTransaction();
        } else {
            this.assertNoTransaction();
        }
        return oDEProcess.createNewMyRoleMex(invocationStyle, qName, string);
    }

    private MyRoleMessageExchange createNewMyRoleMex(ODEProcess oDEProcess, List<MyRoleMessageExchange> list, InvocationStyle invocationStyle) throws BpelEngineException {
        String string = new GUID().toString();
        MyRoleMessageExchange myRoleMessageExchange = list.get(0);
        switch (invocationStyle) {
            case RELIABLE: {
                return new BrokeredReliableMyRoleMessageExchangeImpl(oDEProcess, list, string, myRoleMessageExchange);
            }
            case TRANSACTED: {
                return new BrokeredTransactedMyRoleMessageExchangeImpl(oDEProcess, list, string, myRoleMessageExchange);
            }
            case UNRELIABLE: {
                return new BrokeredUnreliableMyRoleMessageExchangeImpl(oDEProcess, list, string, myRoleMessageExchange);
            }
        }
        throw new BpelEngineException("Unsupported Invocation Style: " + invocationStyle);
    }

    public MessageExchange getMessageExchange(final String string) throws BpelEngineException {
        this._mngmtLock.readLock().lock();
        try {
            Callable<MessageExchange> callable;
            block8: {
                final MessageExchangeDAO messageExchangeDAO = this.getInMemMexDAO(string);
                callable = new Callable<MessageExchange>(){

                    @Override
                    public MessageExchange call() {
                        ODEProcess oDEProcess;
                        MessageExchangeDAO messageExchangeDAO3;
                        MessageExchangeDAO messageExchangeDAO2 = messageExchangeDAO3 = messageExchangeDAO == null ? (messageExchangeDAO3 = BpelServerImpl.this._contexts.dao.getConnection().getMessageExchange(string)) : messageExchangeDAO;
                        if (messageExchangeDAO3 == null) {
                            return null;
                        }
                        ProcessDAO processDAO = messageExchangeDAO3.getProcess();
                        ODEProcess oDEProcess2 = oDEProcess = processDAO == null ? null : (ODEProcess)BpelServerImpl.this._registeredProcesses.get(processDAO.getProcessId());
                        if (oDEProcess == null) {
                            String string2 = __msgs.msgProcessNotActive(processDAO.getProcessId());
                            __log.error((Object)string2);
                            throw new BpelEngineException(string2);
                        }
                        InvocationStyle invocationStyle = messageExchangeDAO3.getInvocationStyle();
                        if (invocationStyle == InvocationStyle.RELIABLE || invocationStyle == InvocationStyle.TRANSACTED) {
                            BpelServerImpl.this.assertTransaction();
                        }
                        switch (messageExchangeDAO3.getDirection()) {
                            case 'P': {
                                return oDEProcess.createPartnerRoleMex(messageExchangeDAO3);
                            }
                            case 'M': {
                                return oDEProcess.lookupMyRoleMex(messageExchangeDAO3);
                            }
                        }
                        String string3 = "BpelEngineImpl: internal error, invalid MexDAO direction: " + string;
                        __log.fatal((Object)string3);
                        throw new BpelEngineException(string3);
                    }
                };
                try {
                    if (messageExchangeDAO == null && !this._contexts.isTransacted()) break block8;
                    MessageExchange messageExchange = (MessageExchange)callable.call();
                    return messageExchange;
                }
                catch (ContextException contextException) {
                    throw new BpelEngineException((Throwable)contextException);
                }
                catch (Exception exception) {
                    throw new BpelEngineException((Throwable)exception);
                }
            }
            MessageExchange messageExchange = this.enqueueTransaction(callable).get();
            return messageExchange;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    public MessageExchange getMessageExchangeByForeignKey(String string) throws BpelEngineException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InvocationStyle> getSupportedInvocationStyle(QName qName) {
        this._mngmtLock.readLock().lock();
        try {
            List<ODEProcess> list = this.route(qName, null);
            if (list == null || list.size() == 0) {
                throw new BpelEngineException("No such service: " + qName);
            }
            HashSet<InvocationStyle> hashSet = new HashSet<InvocationStyle>();
            for (ODEProcess oDEProcess : list) {
                Set<InvocationStyle> set = oDEProcess.getSupportedInvocationStyle(qName);
                if (hashSet.isEmpty()) {
                    hashSet.addAll(set);
                    continue;
                }
                for (InvocationStyle invocationStyle : hashSet) {
                    if (set.contains(invocationStyle)) continue;
                    hashSet.remove(invocationStyle);
                }
            }
            HashSet<InvocationStyle> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageExchangeDAO getInMemMexDAO(String string) {
        this._mngmtLock.readLock().lock();
        try {
            for (ODEProcess oDEProcess : this._registeredProcesses.values()) {
                MessageExchangeDAO messageExchangeDAO = oDEProcess.getInMemMexDAO(string);
                if (messageExchangeDAO == null) continue;
                MessageExchangeDAO messageExchangeDAO2 = messageExchangeDAO;
                return messageExchangeDAO2;
            }
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessModel getProcessModel(QName qName) {
        this._mngmtLock.readLock().lock();
        try {
            ODEProcess oDEProcess = this._registeredProcesses.get(qName);
            if (oDEProcess == null) {
                ProcessModel processModel = null;
                return processModel;
            }
            ProcessModel processModel = oDEProcess.getProcessModel();
            return processModel;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    <T> Future<T> enqueueTransaction(Callable<T> callable) throws ContextException {
        return this._exec.submit(new ServerCallable<T>(new TransactedCallable<T>(callable)));
    }

    void enqueueRunnable(Runnable runnable) {
        this._exec.submit(new ServerRunnable(runnable));
    }

    void scheduleRunnable(final Runnable runnable) {
        this.assertTransaction();
        this._contexts.registerCommitSynchronizer(new Runnable(){

            public void run() {
                BpelServerImpl.this._exec.submit(new ServerRunnable(runnable));
            }
        });
    }

    protected void assertTransaction() {
        if (!this._contexts.isTransacted()) {
            throw new BpelEngineException("Operation must be performed in a transaction!");
        }
    }

    protected void assertNoTransaction() {
        if (this._contexts.isTransacted()) {
            throw new BpelEngineException("Operation must be performed outside of a transaction!");
        }
    }

    void fireEvent(BpelEvent bpelEvent) {
        for (BpelEventListener bpelEventListener : this._contexts.eventListeners) {
            bpelEventListener.onEvent(bpelEvent);
        }
    }

    private void debuggingDelay() {
        if (_delayMean != 0.0) {
            try {
                long l = this.randomExp(_delayMean);
                __log.warn((Object)("Debugging delay has been activated; delaying transaction for " + l + "ms."));
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private long randomExp(double d) {
        double d2 = this._random.nextDouble();
        return (long)(-Math.log(d2) * d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODEProcess getBpelProcess(QName qName) {
        this._mngmtLock.readLock().lock();
        try {
            ODEProcess oDEProcess = this._registeredProcesses.get(qName);
            return oDEProcess;
        }
        finally {
            this._mngmtLock.readLock().unlock();
        }
    }

    private void ticktock() {
        this._lastTimeOfServerCallable.set(System.currentTimeMillis());
    }

    public void setTransacted(boolean bl) {
    }

    static {
        _delayMean = 0.0;
        try {
            String string = System.getProperty("ode.process.maxage");
            if (string != null && string.length() > 0) {
                __processMaxAge = Long.valueOf(string);
                __log.info((Object)("Process definition max age adjusted. Max age = " + __processMaxAge + "ms."));
            }
        }
        catch (Throwable throwable) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Could not parse ode.process.maxage environment variable.", throwable);
            }
            __log.info((Object)"Could not parse ode.process.maxage environment variable; reaping disabled.");
        }
    }

    class TransactedRunnable
    implements Runnable {
        Runnable _work;

        TransactedRunnable(Runnable runnable) {
            this._work = runnable;
        }

        public void run() {
            BpelServerImpl.this._contexts.execTransaction(this._work);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransactedCallable<T>
    implements Callable<T> {
        Callable<T> _work;

        TransactedCallable(Callable<T> callable) {
            this._work = callable;
        }

        @Override
        public T call() throws Exception {
            return BpelServerImpl.this._contexts.execTransaction(this._work);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServerCallable<T>
    implements Callable<T> {
        final Callable<T> _work;

        ServerCallable(Callable<T> callable) {
            this._work = callable;
        }

        @Override
        public T call() throws Exception {
            BpelServerImpl.this.ticktock();
            BpelServerImpl.this._mngmtLock.readLock().lock();
            try {
                BpelServerImpl.this.ticktock();
                T t = this._work.call();
                return t;
            }
            catch (Exception exception) {
                BpelServerImpl.this.ticktock();
                __log.fatal((Object)"Internal Error", (Throwable)exception);
                throw exception;
            }
            finally {
                BpelServerImpl.this._mngmtLock.readLock().unlock();
                BpelServerImpl.this.ticktock();
            }
        }
    }

    class ServerRunnable
    implements Runnable {
        final Runnable _work;

        ServerRunnable(Runnable runnable) {
            this._work = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BpelServerImpl.this.ticktock();
            BpelServerImpl.this._mngmtLock.readLock().lock();
            try {
                BpelServerImpl.this.ticktock();
                this._work.run();
                BpelServerImpl.this.ticktock();
            }
            catch (Throwable throwable) {
                BpelServerImpl.this.ticktock();
                __log.fatal((Object)"Internal Error", throwable);
            }
            finally {
                BpelServerImpl.this._mngmtLock.readLock().unlock();
            }
        }
    }

    private class ProcessDefReaper
    implements Runnable {
        private ProcessDefReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            __log.debug((Object)"Starting process definition reaper thread.");
            long l = 10000L;
            try {
                block5: while (true) {
                    Thread.sleep(l);
                    BpelServerImpl.this._mngmtLock.writeLock().lockInterruptibly();
                    try {
                        ArrayList<ODEProcess> arrayList = new ArrayList<ODEProcess>(BpelServerImpl.this._registeredProcesses.values());
                        CollectionsX.remove_if(arrayList, (MemberOfFunction)new MemberOfFunction<ODEProcess>(){

                            public boolean isMember(ODEProcess oDEProcess) {
                                return !oDEProcess.hintIsHydrated();
                            }
                        });
                        List<ODEProcess> list = BpelServerImpl.this._dehydrationPolicy.markForDehydration(arrayList);
                        Iterator<ODEProcess> iterator = list.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block5;
                            ODEProcess oDEProcess = iterator.next();
                            __log.debug((Object)("Dehydrating process " + oDEProcess.getPID()));
                            oDEProcess.dehydrate();
                        }
                    }
                    finally {
                        BpelServerImpl.this._mngmtLock.writeLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                __log.info((Object)interruptedException);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SHUTDOWN,
        INIT,
        RUNNING;

    }
}

