/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.w3c.dom.Element;

abstract class PartnerRoleMessageExchangeImpl
extends MessageExchangeImpl
implements PartnerRoleMessageExchange {
    private static final Log __log = LogFactory.getLog(PartnerRoleMessageExchangeImpl.class);
    protected final PartnerRoleChannel _partnerRoleChannel;
    protected EndpointReference _myRoleEPR;
    protected String _responseChannel;
    protected volatile String _foreignKey;
    protected Lock _accessLock = new ReentrantLock();
    protected Condition _stateChanged = this._accessLock.newCondition();
    protected Condition _acked = this._accessLock.newCondition();
    private QName _caller;
    protected State _state = State.INVOKE_XXX;

    PartnerRoleMessageExchangeImpl(ODEProcess oDEProcess, Long l, String string, PartnerLinkModel partnerLinkModel, Operation operation, EndpointReference endpointReference, EndpointReference endpointReference2, PartnerRoleChannel partnerRoleChannel) {
        super(oDEProcess, l, string, partnerLinkModel, partnerLinkModel.getPartnerRolePortType(), operation);
        this._myRoleEPR = endpointReference2;
        this._partnerRoleChannel = partnerRoleChannel;
    }

    void load(MessageExchangeDAO messageExchangeDAO) {
        super.load(messageExchangeDAO);
        this._caller = messageExchangeDAO.getProcess().getProcessId();
    }

    void save(MessageExchangeDAO messageExchangeDAO) {
        super.save(messageExchangeDAO);
        messageExchangeDAO.setPartnersKey(this._foreignKey);
        if (this._changes.contains((Object)MessageExchangeImpl.Change.ACK)) {
            this._changes.remove((Object)MessageExchangeImpl.Change.ACK);
            if (this._response != null) {
                MessageDAO messageDAO = messageExchangeDAO.createMessage(this._response.getType());
                messageDAO.setData(this._response.getMessage());
                messageDAO.setHeader(this._response.getHeader());
                messageExchangeDAO.setResponse(messageDAO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ack(MessageExchange.AckType ackType) {
        this._accessLock.lock();
        try {
            super.ack(ackType);
            this._changes.add(MessageExchangeImpl.Change.ACK);
            this._acked.signalAll();
        }
        finally {
            this._accessLock.unlock();
        }
    }

    public void replyAsync(String string) {
        throw new IllegalStateException("replyAsync() is not supported for invocation style " + this.getInvocationStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyOneWayOk() {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("replyOneWayOk mex=" + this.getMessageExchangeId()));
        }
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            this.ack(MessageExchange.AckType.ONEWAY);
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyWithFault(QName qName, Message message) throws BpelEngineException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("replyWithFault mex=" + this.getMessageExchangeId()));
        }
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            this._fault = qName;
            this._failureType = null;
            this._response = (MessageImpl)message;
            this.ack(MessageExchange.AckType.FAULT);
            if (this._state == State.ASYNC) {
                this.asyncACK();
            }
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(Message message) throws BpelEngineException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("reply mex=" + this.getMessageExchangeId()));
        }
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            this._response = (MessageImpl)message;
            this._fault = null;
            this._failureType = null;
            this.ack(MessageExchange.AckType.RESPONSE);
            if (this._state == State.ASYNC) {
                this.asyncACK();
            }
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyWithFailure(MessageExchange.FailureType failureType, String string, Element element) throws BpelEngineException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("replyWithFailure mex=" + this.getMessageExchangeId()));
        }
        this._accessLock.lock();
        try {
            this.checkReplyContextOk();
            this._failureType = failureType;
            this._explanation = string;
            this._fault = null;
            this._response = null;
            this.ack(MessageExchange.AckType.FAILURE);
            if (this._state == State.ASYNC) {
                this.asyncACK();
            }
        }
        finally {
            this._accessLock.unlock();
        }
    }

    public QName getCaller() {
        return this._caller;
    }

    public PartnerRoleChannel getPartnerRoleChannel() {
        return this._partnerRoleChannel;
    }

    public EndpointReference getMyRoleEndpointReference() {
        return this._myRoleEPR;
    }

    public String toString() {
        try {
            return "{PartnerRoleMex#" + this._mexId + " [PID " + this.getCaller() + "] calling " + this._epr + "." + this.getOperationName() + "(...)}";
        }
        catch (Throwable throwable) {
            return "{PartnerRoleMex#????}";
        }
    }

    protected abstract void asyncACK();

    protected void checkReplyContextOk() {
        while (this._state == State.HOLD) {
            try {
                this._stateChanged.await();
            }
            catch (InterruptedException interruptedException) {
                throw new BpelEngineException("Thread Interrupted.", (Throwable)interruptedException);
            }
        }
        if (this._state == State.DEAD) {
            throw new IllegalStateException("Object used in inappropriate context. ");
        }
        if (this.getStatus() != MessageExchange.Status.REQ && this.getStatus() != MessageExchange.Status.ASYNC) {
            throw new IllegalStateException("Invalid message exchange state, expect REQ but got " + this.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(State state) {
        this._accessLock.lock();
        try {
            this._state = state;
            this._stateChanged.signalAll();
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAck(long l) throws InterruptedException {
        this._accessLock.lock();
        try {
            if (this.getStatus() != MessageExchange.Status.ACK) {
                boolean bl = this._acked.await(l, TimeUnit.MILLISECONDS);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._accessLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INVOKE_XXX,
        HOLD,
        ASYNC,
        DEAD;

    }
}

