/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.deltaindexing.impl;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.IdHandlingException;

public class IdIterator
implements Iterator<Id> {
    private final Iterator<Id> _oldIndexIterator;
    private final Set<Id> _newIndex;
    private final Set<Id> _modifiedCompounds;
    private Id _next;

    public IdIterator(Set<Id> oldIndex, Set<Id> newIndex, Set<Id> modifiedCompounds) {
        this._oldIndexIterator = oldIndex.iterator();
        this._newIndex = newIndex;
        this._modifiedCompounds = modifiedCompounds;
    }

    @Override
    public boolean hasNext() {
        if (this._next != null) {
            return true;
        }
        this.tryMoveNext();
        return this._next != null;
    }

    @Override
    public Id next() {
        if (this._next != null) {
            return this.shift();
        }
        this.tryMoveNext();
        return this.shift();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("use delete(Id) method of delta indexing manager instead");
    }

    private void tryMoveNext() {
        this._next = null;
        while (this._oldIndexIterator.hasNext()) {
            Id id = this._oldIndexIterator.next();
            if (this._newIndex.contains(id) || !this.isNotCompoundOrCompoundIsModified(id)) continue;
            this._next = id;
            return;
        }
    }

    private Id shift() {
        Id next = this._next;
        this._next = null;
        return next;
    }

    private boolean isNotCompoundOrCompoundIsModified(Id id) {
        Id parentId = null;
        try {
            parentId = id.createCompoundId();
        }
        catch (IdHandlingException idHandlingException) {}
        if (parentId == null) {
            return true;
        }
        boolean parentVisited = this._newIndex.contains(parentId);
        boolean modifiedCompound = this._modifiedCompounds.contains(parentId);
        return !parentVisited || modifiedCompound;
    }
}

