/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanProcessor
extends ServiceSupport
implements Processor {
    public static final String METHOD_NAME = "org.apache.camel.MethodName";
    private static final transient Log LOG = LogFactory.getLog(BeanProcessor.class);
    private Method methodObject;
    private String method;
    private BeanHolder beanHolder;

    public BeanProcessor(Object pojo, BeanInfo beanInfo) {
        this(new ConstantBeanHolder(pojo, beanInfo));
    }

    public BeanProcessor(Object pojo, CamelContext camelContext, ParameterMappingStrategy parameterMappingStrategy) {
        this(pojo, new BeanInfo(camelContext, pojo.getClass(), parameterMappingStrategy));
    }

    public BeanProcessor(Object pojo, CamelContext camelContext) {
        this(pojo, camelContext, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanProcessor(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public String toString() {
        String description = this.methodObject != null ? " " + this.methodObject : "";
        return "BeanProcessor[" + this.beanHolder + description + "]";
    }

    public void process(Exchange exchange) throws Exception {
        MethodInvocation invocation;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>>> invoking method for: " + exchange));
        }
        Object bean = this.beanHolder.getBean();
        exchange.setProperty("org.apache.camel.bean.BeanHolder", this.beanHolder);
        Processor processor = this.getProcessor();
        BeanInfo beanInfo = this.beanHolder.getBeanInfo();
        if (processor != null) {
            processor.process(exchange);
            return;
        }
        Message in = exchange.getIn();
        BeanInvocation beanInvoke = in.getBody(BeanInvocation.class);
        if (beanInvoke != null) {
            beanInvoke.invoke(bean, exchange);
            return;
        }
        boolean isExplicitMethod = false;
        String prevMethod = null;
        if (this.methodObject != null) {
            invocation = beanInfo.createInvocation(this.methodObject, bean, exchange);
        } else {
            if (ObjectHelper.isNotNullAndNonEmpty(this.method)) {
                prevMethod = in.getHeader(METHOD_NAME, String.class);
                in.setHeader(METHOD_NAME, this.method);
                isExplicitMethod = true;
            }
            invocation = beanInfo.createInvocation(bean, exchange);
        }
        if (invocation == null) {
            throw new IllegalStateException("No method invocation could be created, no maching method could be found on: " + bean);
        }
        try {
            Object value = invocation.proceed();
            if (value != null) {
                if (exchange.getPattern().isOutCapable()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Setting bean invocation value on OUT message: " + value));
                    }
                    exchange.getOut(true).setBody(value);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Setting bean invocation value on IN message: " + value));
                    }
                    exchange.getIn().setBody(value);
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        finally {
            if (isExplicitMethod) {
                in.setHeader(METHOD_NAME, prevMethod);
            }
        }
    }

    protected Processor getProcessor() {
        return this.beanHolder.getProcessor();
    }

    public Method getMethodObject() {
        return this.methodObject;
    }

    public void setMethodObject(Method methodObject) {
        this.methodObject = methodObject;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Deprecated
    public void setMethodName(String method) {
        this.setMethod(method);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService(this.getProcessor());
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.getProcessor());
    }
}

