/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.CachingInjector;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceMethodTypeConverter
implements TypeConverter {
    private final CachingInjector injector;
    private final Method method;

    public InstanceMethodTypeConverter(CachingInjector injector, Method method) {
        this.injector = injector;
        this.method = method;
    }

    public String toString() {
        return "InstanceMethodTypeConverter: " + this.method;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        Object instance = this.injector.newInstance();
        if (instance == null) {
            throw new RuntimeCamelException("Could not instantiate an instance of: " + type.getName());
        }
        return (T)ObjectHelper.invokeMethod(this.method, instance, value);
    }
}

