/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.processor.DelegateProcessor;

public class HandleFaultProcessor
extends DelegateProcessor {
    public void process(Exchange exchange) throws Exception {
        Object faultBody;
        super.process(exchange);
        Message faultMessage = exchange.getFault(false);
        if (faultMessage != null && (faultBody = faultMessage.getBody()) != null) {
            if (faultBody instanceof Throwable) {
                exchange.setException((Throwable)faultBody);
            } else {
                exchange.setException(new CamelException("Message contains fault of type " + faultBody.getClass().getName() + ":\n" + faultBody));
            }
        }
    }
}

