/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.security.processing;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.ProcessingService;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.configuration.PipeletConfigurationLoader;
import org.eclipse.smila.processing.parameters.SearchAnnotations;
import org.eclipse.smila.security.SecurityAnnotation;
import org.eclipse.smila.security.SecurityAnnotations;
import org.eclipse.smila.security.SecurityException;
import org.eclipse.smila.security.SecurityResolver;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class SampleSecurityConverter
implements ProcessingService {
    public static final String BUNDLE_NAME = "org.eclipse.smila.security.processing";
    public static final String CONFIG_FILE = "SampleSecurityConverter.xml";
    public static final String PROP_READ_USERS_ATTRIBUTE_NAME = "readUsersAttributeName";
    public static final String PROP_RESOLVE_GROUPS = "resolveGroups";
    public static final String PROP_RESOLVE_USER_NAMES = "resolveUserNames";
    public static final String PROP_RESOLVED_USER_NAME_PROPERTY_NAME = "resolvedUserNamePropertyName";
    public static final String EXECUTION_MODE = "executionMode";
    private final Log _log = LogFactory.getLog(SampleSecurityConverter.class);
    private PipeletConfiguration _configuration;
    private String _readUsersAttributeName;
    private boolean _resolveGroups;
    private boolean _resolveUserNames;
    private String _resolvedUserNameProperty;
    private SecurityResolver _securityResolver;

    protected void activate(ComponentContext context) throws Exception {
        try {
            if (this._configuration == null) {
                this.readConfiguration();
                this._readUsersAttributeName = (String)this._configuration.getPropertyFirstValueNotNull(PROP_READ_USERS_ATTRIBUTE_NAME);
                this._resolveGroups = (Boolean)this._configuration.getPropertyFirstValueNotNull(PROP_RESOLVE_GROUPS);
                this._resolveUserNames = (Boolean)this._configuration.getPropertyFirstValueNotNull(PROP_RESOLVE_USER_NAMES);
                this._resolvedUserNameProperty = (String)this._configuration.getPropertyFirstValueNotNull(PROP_RESOLVED_USER_NAME_PROPERTY_NAME);
            }
        }
        catch (Exception e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"error initializing SampleSecurityConverter", (Throwable)e);
            }
            throw e;
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        try {
            this._configuration = null;
            this._readUsersAttributeName = null;
            this._resolvedUserNameProperty = null;
        }
        catch (Exception e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"error deactivating SampleSecurityConverter", (Throwable)e);
            }
            throw e;
        }
    }

    public void setSecurityResolver(SecurityResolver securityResolver) {
        this._securityResolver = securityResolver;
    }

    public void unsetSecurityResolver(SecurityResolver securityResolver) {
        if (this._securityResolver == securityResolver) {
            this._securityResolver = null;
        }
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        int i = 0;
        while (i < recordIds.length) {
            block8: {
                try {
                    Annotation pipeletAnnotation = blackboard.getAnnotation(recordIds[i], null, this.getClass().getName());
                    if (pipeletAnnotation != null) {
                        String executionModeValue = pipeletAnnotation.getNamedValue(EXECUTION_MODE);
                        ExecutionMode executionMode = ExecutionMode.valueOf(executionModeValue);
                        switch (executionMode) {
                            case INDEX: {
                                this.convertToAttributes(blackboard, recordIds[i]);
                                break;
                            }
                            case SEARCH: {
                                this.converteToFilter(blackboard, recordIds[i]);
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    if (!this._log.isErrorEnabled()) break block8;
                    this._log.error((Object)("error processing record " + recordIds[i]), (Throwable)ex);
                }
            }
            ++i;
        }
        return recordIds;
    }

    private void convertToAttributes(Blackboard blackboard, Id id) throws BlackboardAccessException, SecurityException {
        SecurityAnnotation sa = new SecurityAnnotation(blackboard.getRecord(id));
        Set<String> readAccessRights = this.getReadAccessRights(sa);
        if (!readAccessRights.isEmpty()) {
            Path path = new Path(this._readUsersAttributeName);
            for (String value : readAccessRights) {
                Literal literal = blackboard.getRecord(id).getFactory().createLiteral();
                literal.setStringValue(value);
                blackboard.addLiteral(id, path, literal);
            }
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("converted security annotations for id " + id + " into attribute values"));
        }
    }

    private void converteToFilter(Blackboard blackboard, Id id) throws BlackboardAccessException, SecurityException {
        SecurityAnnotation sa = new SecurityAnnotation(blackboard.getRecord(id));
        Set<String> readAccessRights = this.getReadAccessRights(sa);
        if (!readAccessRights.isEmpty()) {
            Annotation filter = blackboard.getRecord(id).getFactory().createAnnotation();
            filter.setNamedValue("type", SearchAnnotations.FilterType.ENUMERATION.toString());
            filter.setNamedValue("mode", SearchAnnotations.FilterMode.ANY.name());
            for (String value : readAccessRights) {
                filter.addAnonValue(value);
            }
            Path readUsersAttributePath = new Path(this._readUsersAttributeName);
            if (!blackboard.hasAttribute(id, readUsersAttributePath)) {
                Literal literal = blackboard.getRecord(id).getFactory().createLiteral();
                literal.setStringValue("dummy");
                blackboard.addLiteral(id, readUsersAttributePath, literal);
            }
            blackboard.getRecord(id).getMetadata().getAttribute(this._readUsersAttributeName).addAnnotation("filter", filter);
            blackboard.addAnnotation(id, readUsersAttributePath, "filter", filter);
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("converted security annotations for id " + id + " into query filter"));
        }
    }

    private Set<String> getReadAccessRights(SecurityAnnotation sa) throws BlackboardAccessException, SecurityException {
        HashSet<String> accessRights = new HashSet<String>();
        Collection users = sa.getAccessRights(SecurityAnnotations.AccessRightType.READ, SecurityAnnotations.EntityType.PRINCIPALS).getAnonValues();
        if (this._securityResolver != null) {
            Collection groups;
            if (users != null) {
                for (String user : users) {
                    String userDN = this._securityResolver.resolvePrincipal(user);
                    accessRights.add(userDN);
                }
            }
            if (this._resolveGroups && (groups = sa.getAccessRights(SecurityAnnotations.AccessRightType.READ, SecurityAnnotations.EntityType.GROUPS).getAnonValues()) != null) {
                for (String group : groups) {
                    String groupDN = this._securityResolver.resolvePrincipal(group);
                    Set groupMembers = this._securityResolver.resolveGroupMembers(groupDN);
                    accessRights.addAll(groupMembers);
                }
            }
            HashSet<String> displayNames = new HashSet();
            if (this._resolveUserNames) {
                for (String principalDN : accessRights) {
                    Map properties = this._securityResolver.getProperties(principalDN);
                    Collection resolvedUserNames = (Collection)properties.get(this._resolvedUserNameProperty);
                    if (resolvedUserNames == null || resolvedUserNames.isEmpty()) continue;
                    displayNames.add((String)resolvedUserNames.iterator().next());
                }
            } else {
                displayNames = accessRights;
            }
            return displayNames;
        }
        if (users != null) {
            accessRights.addAll(users);
        }
        return accessRights;
    }

    private void readConfiguration() throws ProcessingException {
        InputStream configurationFileStream = null;
        try {
            try {
                configurationFileStream = ConfigUtils.getConfigStream((String)BUNDLE_NAME, (String)CONFIG_FILE);
                Unmarshaller unmarshaller = PipeletConfigurationLoader.createPipeletConfigurationUnmarshaller();
                this._configuration = (PipeletConfiguration)unmarshaller.unmarshal(configurationFileStream);
            }
            catch (Exception ex) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"Could not read configuration property file SampleSecurityConverter.xml", (Throwable)ex);
                }
                throw new ProcessingException("Could not read configuration property file SampleSecurityConverter.xml", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configurationFileStream);
    }

    public static enum ExecutionMode {
        INDEX,
        SEARCH;

    }
}

