/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.highlighting;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SearchMessage;
import org.eclipse.smila.processing.SearchProcessingService;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DHighlightingTransformer;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformer;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformerException;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.set.DBoolean;
import org.eclipse.smila.search.utils.param.set.DInteger;
import org.eclipse.smila.search.utils.param.set.DParameter;
import org.eclipse.smila.search.utils.param.set.DParameterSet;
import org.eclipse.smila.search.utils.param.set.DString;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class HighlightingService
implements SearchProcessingService {
    public static final String HIGHLIGHTING_TRANSFORMER_REFERENCE = "highlightingTransformer";
    public static final String PROPERTY_HIGHLIGHTING_TRANSFORMER_TYPE = "smila.highlighting.transformer.type";
    public static final String HIGHLIGHTING_TRANSFORMER = "HighlightingTransformer";
    public static final String HIGHLIGHTING_PARAMETER_NAME = "name";
    public static final String HIGHLIGHTING_PARAMETER_VALUE = "value";
    private final Log _log = LogFactory.getLog(HighlightingService.class);
    private ComponentContext _componentContext;
    private HashMap<String, ServiceReference> _highlightingTransformer;

    protected void activate(ComponentContext context) throws Exception {
        this._componentContext = context;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"activating HighlightingService");
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        if (this._highlightingTransformer != null) {
            this._highlightingTransformer.clear();
            this._highlightingTransformer = null;
        }
        this._componentContext = null;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"deactivating HighlightingService");
        }
    }

    protected void setHighlightingTransformer(ServiceReference serviceReference) {
        if (this._highlightingTransformer == null) {
            this._highlightingTransformer = new HashMap();
        }
        if (serviceReference != null) {
            String type = serviceReference.getProperty(PROPERTY_HIGHLIGHTING_TRANSFORMER_TYPE).toString();
            if (type == null) {
                this._log.error((Object)"Cannot use highlighting transformer without property smila.highlighting.transformer.type");
            } else {
                this._highlightingTransformer.put(type, serviceReference);
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Registered highlighting transformer " + type));
                }
            }
        }
    }

    protected void unsetHighlightingTransformer(ServiceReference serviceReference) {
        String type;
        if (this._highlightingTransformer != null && serviceReference != null && (type = serviceReference.getProperty(PROPERTY_HIGHLIGHTING_TRANSFORMER_TYPE).toString()) != null) {
            this._highlightingTransformer.remove(type);
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Unregistered highlighting transformer " + type));
            }
        }
    }

    public SearchMessage process(Blackboard blackboard, SearchMessage message) throws ProcessingException {
        block5: {
            if (message.hasQuery() && message.hasRecords()) {
                try {
                    Map<String, DHighlightingTransformer> highlightConfigs = this.getHighlightingTransforrmerConfigs(blackboard, message.getQuery());
                    if (!highlightConfigs.isEmpty()) {
                        Id[] idArray = message.getRecords();
                        int n = idArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Id id = idArray[n2];
                            this.doHighlighting(blackboard, id, highlightConfigs);
                            ++n2;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!this._log.isErrorEnabled()) break block5;
                    this._log.error((Object)("error processing message " + message.getQuery()), (Throwable)ex);
                }
            }
        }
        return message;
    }

    private Map<String, DHighlightingTransformer> getHighlightingTransforrmerConfigs(Blackboard blackboard, Id id) throws BlackboardAccessException {
        HashMap<String, DHighlightingTransformer> highlightConfigs = new HashMap<String, DHighlightingTransformer>();
        Iterator attributeNames = blackboard.getAttributeNames(id);
        while (attributeNames.hasNext()) {
            Annotation highlight;
            DHighlightingTransformer highlightConfig;
            String attributeName = (String)attributeNames.next();
            Path path = new Path().add(attributeName, -1);
            if (!blackboard.hasAnnotation(id, path, "highlight") || (highlightConfig = this.createHighlightConfig(highlight = blackboard.getAnnotation(id, path, "highlight"))) == null) continue;
            highlightConfigs.put(attributeName, highlightConfig);
        }
        return highlightConfigs;
    }

    private void doHighlighting(Blackboard blackboard, Id id, Map<String, DHighlightingTransformer> highlightConfigs) throws BlackboardAccessException, HighlightingTransformerException, ParameterException {
        for (String attributeName : highlightConfigs.keySet()) {
            Path path = new Path().add(attributeName, -1);
            if (!blackboard.hasAnnotation(id, path, "highlight")) continue;
            Annotation highlight = blackboard.getAnnotation(id, path, "highlight");
            DHighlightingTransformer highlightConfig = highlightConfigs.get(attributeName);
            HighlightingTransformer transformer = null;
            if (this._highlightingTransformer != null) {
                transformer = (HighlightingTransformer)this._componentContext.locateService(HIGHLIGHTING_TRANSFORMER_REFERENCE, this._highlightingTransformer.get(highlightConfig.getName()));
            }
            if (transformer != null) {
                blackboard.setAnnotation(id, path, "highlight", transformer.transform(highlight, highlightConfig.getParameterSet()));
                continue;
            }
            if (!this._log.isWarnEnabled()) continue;
            this._log.warn((Object)("Could not find a HighlightingTransformer with name " + highlightConfig.getName()));
        }
    }

    private DHighlightingTransformer createHighlightConfig(Annotation highlight) {
        if (highlight.hasAnnotation(HIGHLIGHTING_TRANSFORMER)) {
            Annotation highlightingTransformer = highlight.getAnnotation(HIGHLIGHTING_TRANSFORMER);
            DHighlightingTransformer config = new DHighlightingTransformer();
            config.setName(highlightingTransformer.getNamedValue(HIGHLIGHTING_PARAMETER_NAME));
            DParameterSet parameterSet = this.createParameterSet(highlightingTransformer);
            config.setParameterSet(parameterSet);
            return config;
        }
        return null;
    }

    private DParameterSet createParameterSet(Annotation highlightingTransformer) {
        DParameterSet parameterSet = new DParameterSet();
        Iterator paramNames = highlightingTransformer.getAnnotationNames();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            Annotation parameter = highlightingTransformer.getAnnotation(paramName);
            String value = parameter.getNamedValue(HIGHLIGHTING_PARAMETER_VALUE);
            if ("MarkupPrefix".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("MarkupSuffix".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("MaxLength".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDInteger(paramName, Integer.parseInt(value)));
                continue;
            }
            if ("MaxHLElements".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDInteger(paramName, Integer.parseInt(value)));
                continue;
            }
            if ("MaxPrecedingCharacters".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDInteger(paramName, Integer.parseInt(value)));
                continue;
            }
            if ("MaxSucceedingCharacters".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDInteger(paramName, Integer.parseInt(value)));
                continue;
            }
            if ("PrecedingCharacters".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("SucceedingCharacters".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("SortAlgorithm".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("TextHandling".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDString(paramName, value));
                continue;
            }
            if ("HLElementFilter".equals(paramName)) {
                parameterSet.addParameter((DParameter)this.createDBoolean(paramName, Boolean.parseBoolean(value)));
                continue;
            }
            if (!this._log.isWarnEnabled()) continue;
            this._log.warn((Object)("unknown HighlightingTransformer parameter name " + paramName));
        }
        return parameterSet;
    }

    private DInteger createDInteger(String name, int value) {
        DInteger param = new DInteger();
        param.setName(name);
        param.setType("Integer");
        param.setValue(value);
        return param;
    }

    private DString createDString(String name, String value) {
        DString param = new DString();
        param.setName(name);
        param.setType("String");
        param.setValue(value);
        return param;
    }

    private DBoolean createDBoolean(String name, boolean value) {
        DBoolean param = new DBoolean();
        param.setName(name);
        param.setType("Boolean");
        param.setValue(value);
        return param;
    }
}

