/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.highlighting.transformer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.search.highlighting.transformer.HighlightingTransformerException;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.ParameterSet;
import org.eclipse.smila.search.utils.param.def.DParameterDefinition;
import org.eclipse.smila.search.utils.param.def.DParameterDefinitionCodec;
import org.eclipse.smila.search.utils.param.set.DParameterSet;
import org.eclipse.smila.search.utils.searchresult.DHighLighted;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class HighlightingTransformer {
    public static final String PARAM_HL_ELEMENT_FILTER = "HLElementFilter";
    public static final String PARAM_MARKUP_PREFIX = "MarkupPrefix";
    public static final String PARAM_MARKUP_SUFFIX = "MarkupSuffix";
    public static final String PARAM_MAX_HL_ELEMENTS = "MaxHLElements";
    public static final String PARAM_MAX_LENGTH = "MaxLength";
    public static final String PARAM_MAX_PRECEDING_CHARACTERS = "MaxPrecedingCharacters";
    public static final String PARAM_MAX_SUCCEEDING_CHARACTERS = "MaxSucceedingCharacters";
    public static final String PARAM_PRECEDING_CHARACTERS = "PrecedingCharacters";
    public static final String PARAM_SORT_ALGORITHM = "SortAlgorithm";
    public static final String PARAM_SUCCEEDING_CHARACTERS = "SucceedingCharacters";
    public static final String PARAM_TEXT_HANDLING = "TextHandling";
    private DParameterDefinition _parameterDefinition;

    protected abstract ArrayList<Object> transform(ArrayList<Object> var1, ParameterSet var2) throws HighlightingTransformerException;

    public Annotation transform(Annotation highlight, DParameterSet highlightConfig) throws HighlightingTransformerException, ParameterException {
        if (highlight == null) {
            throw new HighlightingTransformerException("no highlight annotation specified for transformation");
        }
        ParameterSet parameterSet = this.createParameterSet(highlightConfig);
        String markupPrefix = parameterSet.getStringParameter(PARAM_MARKUP_PREFIX);
        String markupSuffix = parameterSet.getStringParameter(PARAM_MARKUP_SUFFIX);
        ArrayList<Object> data = new ArrayList<Object>();
        String originalText = highlight.getNamedValue("text");
        Collection highlightPositions = highlight.getAnnotations("positions");
        int pos = 0;
        for (Annotation highlightPos : highlightPositions) {
            int start = Integer.valueOf(highlightPos.getNamedValue("start"));
            int end = Integer.valueOf(highlightPos.getNamedValue("end"));
            data.add(originalText.substring(pos, start));
            String highlightedItem = originalText.substring(start, end);
            int score = Integer.valueOf(highlightPos.getNamedValue("quality"));
            data.add(new DHighLighted(highlightedItem, score));
            pos = end;
        }
        if (pos < originalText.length()) {
            data.add(originalText.substring(pos));
        }
        ArrayList<Object> transformedData = this.transform(data, parameterSet);
        StringBuffer highlightedText = new StringBuffer();
        for (Object obj : transformedData) {
            if (obj instanceof String) {
                highlightedText.append((String)obj);
                continue;
            }
            if (!(obj instanceof DHighLighted)) continue;
            highlightedText.append(String.valueOf(markupPrefix) + ((DHighLighted)obj).getText() + markupSuffix);
        }
        highlight.setNamedValue("text", highlightedText.toString());
        highlight.removeAnnotations("positions");
        return highlight;
    }

    private DParameterDefinition getParameterDefinition() throws ParameterException {
        if (this._parameterDefinition == null) {
            String className = this.getClass().getSimpleName();
            InputStream inputStream = this.getClass().getResourceAsStream(String.valueOf(className) + ".xml");
            try {
                try {
                    DParameterDefinition parameterDefinition;
                    Document document = XMLUtils.parse((InputStream)inputStream, (boolean)true);
                    this._parameterDefinition = parameterDefinition = DParameterDefinitionCodec.decode((Element)document.getDocumentElement());
                }
                catch (Exception exception) {
                    throw new ParameterException("unable to load parameter definition", (Throwable)exception);
                }
            }
            finally {
                if (inputStream != null) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        return this._parameterDefinition;
    }

    protected ParameterSet createParameterSet(DParameterSet dParameterSet) throws ParameterException {
        try {
            ParameterSet paramSet = new ParameterSet(dParameterSet, this.getParameterDefinition());
            return paramSet;
        }
        catch (ParameterException e) {
            throw new ParameterException("unable to parse parameters", (Throwable)e);
        }
    }
}

