/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.service;

import org.eclipse.smila.utils.UtilsActivator;
import org.eclipse.smila.utils.log.BundleLogHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class ServiceUtils<T> {
    private static final int DEFAULT_SERVICE_MAX_WAITING = 10000;

    private ServiceUtils() {
    }

    private static Object getService(BundleContext context, String clazz, long timeout) throws InterruptedException {
        Object service;
        ServiceReference reference = context.getServiceReference(clazz);
        if (reference != null && (service = context.getService(reference)) != null) {
            return service;
        }
        ServiceTracker st = null;
        try {
            st = new ServiceTracker(context, clazz, null);
            st.open();
            st.waitForService(timeout);
            if (st.getService() == null) {
                BundleLogHelper.logBundlesState();
                throw new RuntimeException("Unable to find service " + clazz);
            }
            Object object = st.getService();
            return object;
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public static <T> T getService(BundleContext context, Class<T> clazz, long timeout) throws InterruptedException {
        return (T)ServiceUtils.getService(context, clazz.getName(), timeout);
    }

    public static <T> T getService(BundleContext context, Class<T> clazz) throws InterruptedException {
        return (T)ServiceUtils.getService(context, clazz.getName(), 10000L);
    }

    public static <T> T getService(Class<T> clazz, long timeout) throws InterruptedException {
        return ServiceUtils.getService(UtilsActivator.getBundleContext(), clazz, timeout);
    }

    public static <T> T getService(Class<T> clazz) throws InterruptedException {
        return ServiceUtils.getService(clazz, 10000L);
    }
}

