/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.persistence.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.config.BinaryStorageConfiguration;

public class BssIOUtils {
    private static File _root = null;
    private static final int FILE_SIZE_64MB = 0x4000000;
    private static final int FILE_SIZE_TRANSFER = 67076096;

    public static void init(BinaryStorageConfiguration binaryStorageConfig) {
        _root = BssIOUtils.getCanonicalFile(binaryStorageConfig.getPath());
    }

    private static File getCanonicalFile(String filePath) {
        File file = new File(filePath);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    public static void writeInputStreamToFile(String path, InputStream stream) throws BinaryStorageException {
        File record = BssIOUtils.mkdirForFileRecord(path);
        if (stream instanceof FileInputStream) {
            try {
                BssIOUtils.writeCopyByChannels(record.getCanonicalPath(), stream);
            }
            catch (IOException ioe) {
                throw new BinaryStorageException((Throwable)ioe, "Could not write from input stream to record :" + path);
            }
        }
        FileOutputStream output = null;
        try {
            try {
                output = FileUtils.openOutputStream((File)record);
                IOUtils.copy((InputStream)stream, (OutputStream)output);
            }
            catch (IOException ioe) {
                throw new BinaryStorageException((Throwable)ioe, "Could not write from input stream to record :" + path);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    private static void writeCopyByChannels(String path, InputStream stream) throws BinaryStorageException {
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            try {
                inChannel = ((FileInputStream)stream).getChannel();
                outChannel = new FileOutputStream(path).getChannel();
                if (inChannel.size() < 0x4000000L) {
                    outChannel.transferFrom(inChannel, 0L, inChannel.size());
                } else {
                    long size = inChannel.size();
                    long position = 0L;
                    while (position < size) {
                        position += inChannel.transferTo(position, 67076096L, outChannel);
                    }
                }
            }
            catch (IOException ioe) {
                throw new BinaryStorageException((Throwable)ioe, "Could not write binary record to :" + path);
            }
        }
        catch (Throwable throwable) {
            BssIOUtils.closeChannel(inChannel);
            BssIOUtils.closeChannel(outChannel);
            throw throwable;
        }
        BssIOUtils.closeChannel(inChannel);
        BssIOUtils.closeChannel(outChannel);
    }

    private static void closeChannel(FileChannel channel) throws BinaryStorageException {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException exception) {
                throw new BinaryStorageException((Throwable)exception, "Could not close stream channel.");
            }
        }
    }

    public static void writeByteArrayToFile(String path, byte[] data) throws BinaryStorageException {
        File record = BssIOUtils.mkdirForFileRecord(path);
        try {
            FileUtils.writeByteArrayToFile((File)record, (byte[])data);
        }
        catch (IOException ioe) {
            throw new BinaryStorageException((Throwable)ioe, "Could not write binary record to :" + path);
        }
    }

    private static synchronized File mkdirForFileRecord(String path) throws BinaryStorageException {
        File record = BssIOUtils.getFile(path);
        try {
            if (!BssIOUtils.isRecordParentRoot(record)) {
                FileUtils.forceMkdir((File)record.getParentFile());
            }
            return record;
        }
        catch (IOException ioe) {
            throw new BinaryStorageException((Throwable)ioe, "Could not write binary record to :" + path);
        }
    }

    private static boolean isRecordParentRoot(File record) {
        return record.getParentFile().equals(_root);
    }

    public static byte[] readFileToByteArray(String path) throws BinaryStorageException {
        try {
            return FileUtils.readFileToByteArray((File)BssIOUtils.getFile(path));
        }
        catch (IOException ioe) {
            throw new BinaryStorageException((Throwable)ioe, "Could not read binary record from :" + path);
        }
    }

    public static InputStream readFileToInputStream(String path) throws BinaryStorageException {
        File source = BssIOUtils.getFile(path);
        try {
            return new DataInputStream(new BufferedInputStream(new FileInputStream(source)));
        }
        catch (IOException ioe) {
            throw new BinaryStorageException((Throwable)ioe, "Could not read binary record from :" + path);
        }
    }

    public static void deleteFile(String key) {
        FileUtils.deleteQuietly((File)BssIOUtils.getFile(key));
    }

    public static File getFile(String key) {
        return new File(_root, key);
    }

    public static long fetchSize(String key) throws BinaryStorageException {
        File file = BssIOUtils.getFile(key);
        if (file.exists()) {
            return file.length();
        }
        throw new BinaryStorageException("file does not exist: " + key);
    }

    public static void deleteEmptyParentFolders(File leafFolder) {
        while (leafFolder != null && leafFolder.list().length < 1 && !leafFolder.equals(_root)) {
            leafFolder.delete();
            leafFolder = leafFolder.getParentFile();
        }
    }
}

