/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.recordstorage.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.recordstorage.RecordStorage;
import org.eclipse.smila.recordstorage.RecordStorageException;
import org.eclipse.smila.recordstorage.util.RecordDao;
import org.eclipse.smila.recordstorage.util.RecordIterator;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.osgi.service.component.ComponentContext;

public class RecordStorageImpl
implements RecordStorage {
    public static final String BUNDLE_NAME = "org.eclipse.smila.recordstorage.impl";
    public static final String PERSISTENCE_UNIT_NAME = "SmilaRecord";
    public static final String CONFIGURATION_FILE = "persistence.properties";
    private final Log _log = LogFactory.getLog(RecordStorageImpl.class);
    private ReadWriteLock _lock = new ReentrantReadWriteLock(true);
    private Properties _properties;
    private EntityManagerFactory _emf;

    public RecordStorageImpl() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"creating instance of RecordStorageImpl");
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        EntityManager em = null;
        try {
            try {
                this.readConfiguration();
                if (!this._properties.containsKey("eclipselink.logging.file")) {
                    File workingDir = WorkspaceHelper.createWorkingDir((String)BUNDLE_NAME);
                    File logfile = new File(workingDir, "jpa.log");
                    this._properties.put("eclipselink.logging.file", logfile.getAbsolutePath());
                }
                this._emf = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, (Map)this._properties);
                em = this._emf.createEntityManager();
            }
            catch (Exception e) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"error activating RecordStorageImpl service", (Throwable)e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.closeEntityManager(em);
            throw throwable;
        }
        this.closeEntityManager(em);
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"started RecordStorageImpl service");
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        this._lock.writeLock().lock();
        try {
            block8: {
                try {
                    if (this._emf != null) {
                        this._emf.close();
                    }
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) break block8;
                    this._log.error((Object)"error closing EntityManagerFactory", (Throwable)e);
                }
            }
            this._emf = null;
            if (this._properties != null) {
                this._properties.clear();
                this._properties = null;
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)"deactivated RecordStorageImpl service");
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Record loadRecord(Id id) throws RecordStorageException {
        if (id == null) {
            throw new RecordStorageException("parameter id is null");
        }
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            try {
                RecordDao dao = this.findRecordDao(em, id);
                if (dao != null) {
                    Record record = dao.toRecord();
                    return record;
                }
                return null;
            }
            catch (Exception e) {
                throw new RecordStorageException((Throwable)e, "error loading record id: " + id);
            }
            finally {
                this.closeEntityManager(em);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void storeRecord(Record record) throws RecordStorageException {
        if (record == null) {
            throw new RecordStorageException("parameter record is null");
        }
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            try {
                try {
                    RecordDao dao = new RecordDao(record);
                    transaction.begin();
                    if (this.findRecordDao(em, record.getId()) == null) {
                        em.persist((Object)dao);
                    } else {
                        em.merge((Object)dao);
                    }
                    transaction.commit();
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("stored record Id:" + record.getId()));
                    }
                }
                catch (Exception e) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new RecordStorageException((Throwable)e, "error storing record id: " + record.getId());
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void removeRecord(Id id) throws RecordStorageException {
        block12: {
            if (id == null) {
                throw new RecordStorageException("parameter id is null");
            }
            this._lock.readLock().lock();
            try {
                EntityManager em = this.createEntityManager();
                try {
                    RecordDao dao = this.findRecordDao(em, id);
                    if (dao != null) {
                        EntityTransaction transaction = em.getTransaction();
                        try {
                            transaction.begin();
                            em.remove((Object)dao);
                            transaction.commit();
                            break block12;
                        }
                        catch (Exception e) {
                            if (transaction.isActive()) {
                                transaction.rollback();
                            }
                            throw new RecordStorageException((Throwable)e, "error removing record id: " + id);
                        }
                    }
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("could not remove record id: " + id + ". no record with this id exists."));
                    }
                }
                finally {
                    this.closeEntityManager(em);
                }
            }
            finally {
                this._lock.readLock().unlock();
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean existsRecord(Id id) throws RecordStorageException {
        if (id == null) {
            throw new RecordStorageException("parameter id is null");
        }
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            try {
                RecordDao dao = this.findRecordDao(em, id);
                return dao != null;
                {
                }
            }
            catch (Exception e) {
                throw new RecordStorageException((Throwable)e, "error checking existence of record id: " + id);
            }
            finally {
                this.closeEntityManager(em);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Iterator<Record> loadRecords(String source) throws RecordStorageException {
        if (source == null) {
            throw new RecordStorageException("parameter source is null");
        }
        if (source.trim().length() == 0) {
            throw new RecordStorageException("parameter source is an empty String");
        }
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            try {
                Query query = em.createNamedQuery("RecordDao.findBySource");
                List daos = query.setParameter("source", (Object)source).getResultList();
                if (daos.isEmpty() && this._log.isInfoEnabled()) {
                    this._log.info((Object)("loadRecords could not find any records for source: " + source));
                }
                RecordIterator recordIterator = new RecordIterator(daos.iterator());
                return recordIterator;
            }
            catch (Exception e) {
                throw new RecordStorageException((Throwable)e, "error executing loadRecords with source: " + source);
            }
            finally {
                this.closeEntityManager(em);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    private RecordDao findRecordDao(EntityManager em, Id id) {
        return (RecordDao)em.find(RecordDao.class, (Object)id.getIdHash());
    }

    private void readConfiguration() throws IOException {
        this._properties = new Properties();
        InputStream configurationFileStream = null;
        try {
            try {
                configurationFileStream = ConfigUtils.getConfigStream((String)BUNDLE_NAME, (String)CONFIGURATION_FILE);
                this._properties.load(configurationFileStream);
            }
            catch (IOException ex) {
                throw new IOException("Could not read configuration property file persistence.properties: " + ex.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configurationFileStream);
    }

    private EntityManager createEntityManager() throws RecordStorageException {
        if (this._emf == null) {
            throw new RecordStorageException("RecordStorage is not active anymore. Maybe this system is shutting down?");
        }
        return this._emf.createEntityManager();
    }

    private void closeEntityManager(EntityManager em) {
        block3: {
            try {
                if (em != null) {
                    em.close();
                }
            }
            catch (Exception e) {
                if (!this._log.isErrorEnabled()) break block3;
                this._log.error((Object)"error closing local EntityManager", (Throwable)e);
            }
        }
    }
}

