/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.pipelets.xmlprocessing.AXmlTransformationPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.NullPrintWriter;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;

public class TidyPipelet
extends AXmlTransformationPipelet {
    public static final String PROP_TIDY_FILE = "tidyFile";
    private String _tidyFile;
    private Tidy _tidy;

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        super.configure(configuration);
        this._tidyFile = (String)configuration.getPropertyFirstValue(PROP_TIDY_FILE);
        this._tidy = new Tidy();
        if (this._tidyFile != null) {
            File f = new File(this._tidyFile);
            if (!f.exists()) {
                throw new ProcessingException("unable to load tidy configuration file [" + this._tidyFile + "]");
            }
            this._tidy.setConfigurationFromFile(this._tidyFile);
        } else {
            this._tidy.setXHTML(true);
            this._tidy.setQuiet(true);
            this._tidy.setErrout((PrintWriter)new NullPrintWriter());
        }
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                block19: {
                    Id id = idArray[n2];
                    ByteArrayInputStream bais = null;
                    try {
                        try {
                            byte[] input = this.readInput(blackboard, id);
                            if (input != null && input.length > 0) {
                                bais = new ByteArrayInputStream(input);
                                Document result = this._tidy.parseDOM((InputStream)bais, null);
                                this.storeDocument(blackboard, id, result);
                            }
                        }
                        catch (Exception e) {
                            if (this._log.isWarnEnabled()) {
                                this._log.warn((Object)("unable to tidy document " + id), (Throwable)e);
                            }
                            if (bais != null) {
                                try {
                                    bais.close();
                                }
                                catch (IOException e2) {
                                    if (this._log.isWarnEnabled()) {
                                        this._log.warn((Object)"error closing tidy InputStream", (Throwable)e2);
                                    }
                                }
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        block20: {
                            if (bais != null) {
                                try {
                                    bais.close();
                                }
                                catch (IOException e) {
                                    if (!this._log.isWarnEnabled()) break block20;
                                    this._log.warn((Object)"error closing tidy InputStream", (Throwable)e);
                                }
                            }
                        }
                        throw throwable;
                    }
                    if (bais != null) {
                        try {
                            bais.close();
                        }
                        catch (IOException e) {
                            if (!this._log.isWarnEnabled()) break block19;
                            this._log.warn((Object)"error closing tidy InputStream", (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
        }
        return recordIds;
    }
}

