/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.pipelets.xmlprocessing.AXmlTransformationPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XMLUtils;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XPathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathFilterPipelet
extends AXmlTransformationPipelet {
    public static final String PROP_XPATH = "xpath";
    public static final String PROP_FILTER_MODE = "filterMode";
    public static final String PROP_SEPERATOR = "seperator";
    public static final String PROP_NAMESPACE = "namespace";
    public static final String PROP_ROOT_ELEMENT = "rootElement";
    private String[] _xpaths;
    private XPathFilerMode _filterMode = XPathFilerMode.INCLUDE;
    private String _separator;
    private String _namespace;
    private Element _namespaceElement;
    private String _root;

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        super.configure(configuration);
        this._xpaths = configuration.getPropertyStringValues(PROP_XPATH);
        if (this._xpaths == null || this._xpaths.length == 0) {
            throw new ProcessingException("Property xpath must not be Null or an empty String");
        }
        String mode = (String)configuration.getPropertyFirstValue(PROP_FILTER_MODE);
        if (mode != null) {
            this._filterMode = XPathFilerMode.valueOf(mode);
        }
        this._separator = (String)configuration.getPropertyFirstValue(PROP_SEPERATOR);
        if (this._separator == null) {
            this._separator = "";
        }
        this._namespace = (String)configuration.getPropertyFirstValue(PROP_NAMESPACE);
        if (this._namespace == null) {
            this._namespace = "";
        }
        if (XPathFilerMode.INCLUDE.equals((Object)this._filterMode)) {
            this._root = (String)configuration.getPropertyFirstValue(PROP_ROOT_ELEMENT);
            if (this._root == null || this._root.trim().length() == 0) {
                throw new ProcessingException("Property rootElement must not be Null or an empty String");
            }
        }
        Document doc = XMLUtils.getDocument();
        this._namespaceElement = doc.createElement("NamespaceDef");
        String[] namespaces = this._namespace.split(" ");
        int i = 0;
        while (i < namespaces.length) {
            if (!"".equals(namespaces[i].trim())) {
                String[] nsItems = namespaces[i].split("=");
                if (nsItems.length != 2) {
                    throw new ProcessingException("Property namespace in invalid format [Namespace;ns1=val ns2=val]");
                }
                this._namespaceElement.setAttribute("xmlns:" + nsItems[0], nsItems[1]);
            }
            ++i;
        }
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    Id id = idArray[n2];
                    try {
                        Document inputDocument = this.createDocument(blackboard, id);
                        if (inputDocument != null) {
                            Document result = XPathFilerMode.INCLUDE.equals((Object)this._filterMode) ? this.includeElements(inputDocument) : this.excludeElements(inputDocument);
                            this.storeDocument(blackboard, id, result);
                        }
                    }
                    catch (Exception e) {
                        if (!this._log.isWarnEnabled()) break block5;
                        this._log.warn((Object)("unable to transform document " + id), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return recordIds;
    }

    private Document includeElements(Document inputDocument) throws ProcessingException {
        Document doc = XMLUtils.getDocument();
        Element rootElement = doc.createElement(this._root);
        doc.appendChild(rootElement);
        try {
            String[] stringArray = this._xpaths;
            int n = this._xpaths.length;
            int n2 = 0;
            while (n2 < n) {
                String xpath = stringArray[n2];
                XObject xobj = XPathAPI.eval((Node)inputDocument, (String)xpath, (Node)this._namespaceElement);
                NodeList nl = xobj.nodelist();
                int i = 0;
                while (i < nl.getLength()) {
                    Node n3 = nl.item(i);
                    rootElement.appendChild(doc.importNode(n3, true));
                    ++i;
                }
                ++n2;
            }
        }
        catch (TransformerException e) {
            throw new ProcessingException("Transformer exception: " + e.getMessage());
        }
        return doc;
    }

    private Document excludeElements(Document inputDocument) {
        String[] stringArray = this._xpaths;
        int n = this._xpaths.length;
        int n2 = 0;
        while (n2 < n) {
            String xpath = stringArray[n2];
            XPathUtils.removeNodesByXPath(inputDocument, xpath, this._namespaceElement);
            ++n2;
        }
        return inputDocument;
    }

    public static enum XPathFilerMode {
        INCLUDE,
        EXCLUDE;

    }
}

