/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.pipelets.xmlprocessing.AXmlTransformationPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XslTransformer;
import org.w3c.dom.Document;

public class XslTransformationPipelet
extends AXmlTransformationPipelet {
    public static final String PROP_XSL_FILE = "xslFile";
    private String _xslFile;
    private XslTransformer _xslTransformer;

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        super.configure(configuration);
        this._xslFile = (String)configuration.getPropertyFirstValueNotNull(PROP_XSL_FILE);
        this._xslTransformer = new XslTransformer();
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    Id id = idArray[n2];
                    try {
                        Document inputDocument = this.createDocument(blackboard, id);
                        if (inputDocument != null) {
                            Document result = this._xslTransformer.transform(inputDocument, this._xslFile);
                            this.storeDocument(blackboard, id, result);
                        }
                    }
                    catch (Exception e) {
                        if (!this._log.isWarnEnabled()) break block5;
                        this._log.warn((Object)("unable to transform document " + id), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return recordIds;
    }
}

