/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.lucene;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.lucene.LuceneServie;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.ProcessingService;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DAnyFinderDataDictionary;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.index.IndexAdmin;
import org.eclipse.smila.search.index.IndexConnection;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.index.IndexManager;
import org.eclipse.smila.search.lucene.index.access.IndexWriterPool;
import org.eclipse.smila.search.plugin.IIndexAccess;
import org.eclipse.smila.search.plugin.Plugin;
import org.eclipse.smila.search.plugin.PluginFactory;
import org.eclipse.smila.utils.log.RecordLifecycleLogHelper;
import org.osgi.service.component.ComponentContext;

public class LuceneIndexService
extends LuceneServie
implements ProcessingService {
    public static final String PROPERTY_TEMPORARY_INDEX_DIR = "temporaryIndexDir";
    public static final String PROPERTY_FORCE_UNLOCK_INDEX = "forceUnlockIndex";
    public static final String ALLOW_DOUBLETS = "allowDoublets";
    public static final String EXECUTION_MODE = "executionMode";
    private final Log _log = LogFactory.getLog(LuceneIndexService.class);
    private IndexAdmin _indexAdmin;
    private Set<String> _indices = Collections.synchronizedSet(new HashSet());
    private ReadWriteLock _lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) throws Exception {
        Set<String> set = this._indices;
        synchronized (set) {
            try {
                this.loadMappings();
                Plugin plugin = PluginFactory.getPlugin();
                IIndexAccess indexAccess = plugin.getIndexAccess();
                this._indexAdmin = indexAccess.getIndexAdmin();
                DAnyFinderDataDictionary dic = DataDictionaryController.getDataDictionary();
                Enumeration indices = dic.getIndices();
                while (indices.hasMoreElements()) {
                    DIndex dIndex = (DIndex)indices.nextElement();
                    if (!this._indexAdmin.exists(dIndex.getName())) {
                        if (this._log.isInfoEnabled()) {
                            this._log.info((Object)("Physical Index [" + dIndex.getName() + "] doesn\ufffd\ufffdt exist. Adapt DataDictionary."));
                        }
                        DataDictionaryController.deleteIndex((String)dIndex.getName());
                        continue;
                    }
                    this._indices.add(dIndex.getName());
                }
            }
            catch (Exception e) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"error initializing LuceneIndexService", (Throwable)e);
                }
                throw e;
            }
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        this._lock.writeLock().lock();
        try {
            try {
                this._indices = null;
                this._indexAdmin = null;
                this.unloadMappings();
            }
            catch (Exception e) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"error deactivating LuceneIndexService", (Throwable)e);
                }
                throw e;
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        this._lock.readLock().lock();
        try {
            int i = 0;
            while (i < recordIds.length) {
                block12: {
                    try {
                        Annotation pipeletAnnotation = blackboard.getAnnotation(recordIds[i], null, this.getClass().getName());
                        if (pipeletAnnotation == null) break block12;
                        String executionModeValue = pipeletAnnotation.getNamedValue(EXECUTION_MODE);
                        String indexName = pipeletAnnotation.getNamedValue("indexName");
                        boolean allowDoublets = Boolean.valueOf(pipeletAnnotation.getNamedValue(ALLOW_DOUBLETS));
                        ExecutionMode executionMode = ExecutionMode.valueOf(executionModeValue);
                        switch (executionMode) {
                            case ADD: {
                                this.addRecord(blackboard, recordIds[i], indexName, allowDoublets);
                                if (RecordLifecycleLogHelper.isRecordStateLogEnabled()) {
                                    RecordLifecycleLogHelper.logRecordState((String)"Record added to lucene index", (String)recordIds[i].getIdHash());
                                }
                                break;
                            }
                            case DELETE: {
                                this.deleteRecord(recordIds[i], indexName);
                                if (RecordLifecycleLogHelper.isRecordStateLogEnabled()) {
                                    RecordLifecycleLogHelper.logRecordState((String)"Record deleted from lucene index", (String)recordIds[i].getIdHash());
                                }
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!this._log.isErrorEnabled()) break block12;
                        this._log.error((Object)("error processing record " + recordIds[i]), (Throwable)ex);
                    }
                }
                ++i;
            }
            Id[] idArray = recordIds;
            return idArray;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecord(Blackboard blackboard, Id id, String indexName, boolean allowDoublets) throws BlackboardAccessException, IndexException, IOException, ParserConfigurationException {
        block13: {
            if (!this.isIndexExists(indexName)) {
                Set<String> set = this._indices;
                synchronized (set) {
                    if (!this.isIndexExists(indexName)) {
                        this.createIndex(indexName);
                    }
                }
            }
            IndexConnection indexConnection = null;
            try {
                indexConnection = IndexManager.getInstance((String)indexName);
                if (indexConnection != null) {
                    HashMap<String, HashMap<String, Integer>> indexMap;
                    if (!allowDoublets && indexConnection.docExists(id)) {
                        indexConnection.deleteDocument(id);
                    }
                    if ((indexMap = this.getMappings().get(indexName)) != null) {
                        indexConnection.learnDocument(blackboard, id, (Map)indexMap.get("attributes"), (Map)indexMap.get("attachments"));
                        if (this._log.isInfoEnabled()) {
                            this._log.info((Object)("adding record " + id + " to Lucene index"));
                        }
                        break block13;
                    }
                    throw new IndexException("Could not find a mapping in file Mappings.xml for index " + indexName);
                }
                throw new IndexException("Could not open connection to index " + indexName);
            }
            finally {
                if (indexConnection != null) {
                    IndexManager.releaseInstance((IndexConnection)indexConnection, (boolean)false);
                }
            }
        }
    }

    private void deleteRecord(Id id, String indexName) throws IndexException {
        block6: {
            IndexConnection indexConnection = null;
            try {
                indexConnection = IndexManager.getInstance((String)indexName);
                if (indexConnection != null) {
                    indexConnection.deleteDocument(id);
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("deleted record " + id + " from Lucene index"));
                    }
                    break block6;
                }
                throw new IndexException("Could not open connection to index " + indexName);
            }
            finally {
                if (indexConnection != null) {
                    IndexManager.releaseInstance((IndexConnection)indexConnection, (boolean)false);
                }
            }
        }
    }

    public boolean isIndexExists(String indexName) throws IndexException {
        return this._indices.contains(indexName);
    }

    public void reorganizeIndex(String indexName) throws IndexException {
        this._indexAdmin.reorganize(indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(String indexName) throws IndexException {
        Set<String> set = this._indices;
        synchronized (set) {
            if (this.isIndexExists(indexName)) {
                throw new IndexException(String.format("Index [%s] already exists", indexName));
            }
            try {
                DataDictionaryController.addIndex((String)indexName);
                DIndex dIndex = DataDictionaryController.getIndex((String)indexName);
                this._indexAdmin.create(dIndex.getIndexStructure());
                this._indices.add(dIndex.getName());
            }
            catch (DataDictionaryException e) {
                throw new IndexException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndex(String indexName) throws IndexException {
        Set<String> set = this._indices;
        synchronized (set) {
            this._indexAdmin.delete(indexName);
            this._indices.remove(indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameIndex(String indexName, String newIndexName) throws IndexException {
        Set<String> set = this._indices;
        synchronized (set) {
            this._indexAdmin.rename(indexName, newIndexName);
            this._indices.remove(indexName);
            this._indices.add(newIndexName);
        }
    }

    public Iterator<String> getIndexNames() {
        return this._indices.iterator();
    }

    public void flushIndex(String indexName) throws IndexException {
        IndexWriterPool.flushIndexWriter(indexName);
    }

    public void removeWriteLock(String indexName) throws IndexException {
        IndexConnection indexConnection = IndexManager.getInstance((String)indexName);
        if (indexConnection != null) {
            indexConnection.unlock();
        }
    }

    public static enum ExecutionMode {
        ADD,
        DELETE;

    }
}

