/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.lucene;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.eclipse.smila.lucene.config.Attachment;
import org.eclipse.smila.lucene.config.Attribute;
import org.eclipse.smila.lucene.config.Mapping;
import org.eclipse.smila.lucene.config.Mappings;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.config.ConfigurationLoadException;
import org.eclipse.smila.utils.jaxb.JaxbUtils;

public final class MappingsLoader {
    public static final String BUNDLE_ID = "org.eclipse.smila.lucene";
    public static final String XSD_FILE = "schemas/Mappings.xsd";
    public static final String ATTRIBUTES = "attributes";
    public static final String ATTACHMENTS = "attachments";

    private MappingsLoader() {
    }

    public static Object loadMappings(String fileName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(MappingsLoader.class.getClassLoader());
        try {
            Object object = JaxbUtils.unmarshall((String)BUNDLE_ID, (String)"org.eclipse.smila.lucene.config", (ClassLoader)MappingsLoader.class.getClassLoader(), (String)XSD_FILE, (InputStream)ConfigUtils.getConfigStream((String)BUNDLE_ID, (String)fileName));
            return object;
        }
        catch (Throwable e) {
            throw new ConfigurationLoadException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static HashMap<String, HashMap<String, HashMap<String, Integer>>> loadMappingsMap(String fileName) {
        HashMap<String, HashMap<String, HashMap<String, Integer>>> indexMap = new HashMap<String, HashMap<String, HashMap<String, Integer>>>();
        Mappings mappings = (Mappings)MappingsLoader.loadMappings(fileName);
        if (mappings != null) {
            List<Mapping> list = mappings.getMapping();
            for (Mapping mappingType : list) {
                HashMap mappingMap = new HashMap();
                if (mappingType.getAttributes() != null) {
                    List<Attribute> attribList = mappingType.getAttributes().getAttribute();
                    HashMap<String, Integer> attribMap = new HashMap<String, Integer>();
                    for (Attribute attribute : attribList) {
                        attribMap.put(attribute.getName(), attribute.getFieldNo());
                    }
                    mappingMap.put(ATTRIBUTES, attribMap);
                }
                if (mappingType.getAttachments() != null) {
                    List<Attachment> attachList = mappingType.getAttachments().getAttachment();
                    HashMap<String, Integer> attachMap = new HashMap<String, Integer>();
                    for (Attachment attachment : attachList) {
                        attachMap.put(attachment.getName(), attachment.getFieldNo());
                    }
                    mappingMap.put(ATTACHMENTS, attachMap);
                }
                indexMap.put(mappingType.getIndexName(), mappingMap);
            }
        }
        return indexMap;
    }
}

