/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.FragmentQueue;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenGroup;

public class Highlighter {
    public static final int DEFAULT_MAX_DOC_BYTES_TO_ANALYZE = 51200;
    private int maxDocBytesToAnalyze = 51200;
    private Formatter formatter;
    private Encoder encoder;
    private Fragmenter textFragmenter = new SimpleFragmenter();
    private Scorer fragmentScorer = null;

    public Highlighter(Scorer fragmentScorer) {
        this(new SimpleHTMLFormatter(), fragmentScorer);
    }

    public Highlighter(Formatter formatter, Scorer fragmentScorer) {
        this(formatter, new DefaultEncoder(), fragmentScorer);
    }

    public Highlighter(Formatter formatter, Encoder encoder, Scorer fragmentScorer) {
        this.formatter = formatter;
        this.encoder = encoder;
        this.fragmentScorer = fragmentScorer;
    }

    public final String getBestFragment(Analyzer analyzer, String fieldName, String text) throws IOException {
        TokenStream tokenStream = analyzer.tokenStream(fieldName, (Reader)new StringReader(text));
        return this.getBestFragment(tokenStream, text);
    }

    public final String getBestFragment(TokenStream tokenStream, String text) throws IOException {
        String[] results = this.getBestFragments(tokenStream, text, 1);
        if (results.length > 0) {
            return results[0];
        }
        return null;
    }

    public final String[] getBestFragments(Analyzer analyzer, String text, int maxNumFragments) throws IOException {
        TokenStream tokenStream = analyzer.tokenStream("field", (Reader)new StringReader(text));
        return this.getBestFragments(tokenStream, text, maxNumFragments);
    }

    public final String[] getBestFragments(Analyzer analyzer, String fieldName, String text, int maxNumFragments) throws IOException {
        TokenStream tokenStream = analyzer.tokenStream(fieldName, (Reader)new StringReader(text));
        return this.getBestFragments(tokenStream, text, maxNumFragments);
    }

    public final String[] getBestFragments(TokenStream tokenStream, String text, int maxNumFragments) throws IOException {
        maxNumFragments = Math.max(1, maxNumFragments);
        TextFragment[] frag = this.getBestTextFragments(tokenStream, text, true, maxNumFragments);
        ArrayList<String> fragTexts = new ArrayList<String>();
        for (int i = 0; i < frag.length; ++i) {
            if (frag[i] == null || !(frag[i].getScore() > 0.0f)) continue;
            fragTexts.add(frag[i].toString());
        }
        return fragTexts.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextFragment[] getBestTextFragments(TokenStream tokenStream, String text, boolean mergeContiguousFragments, int maxNumFragments) throws IOException {
        ArrayList<TextFragment> docFrags = new ArrayList<TextFragment>();
        StringBuffer newText = new StringBuffer();
        TextFragment currentFrag = new TextFragment(newText, newText.length(), docFrags.size());
        this.fragmentScorer.startFragment(currentFrag);
        docFrags.add(currentFrag);
        FragmentQueue fragQueue = new FragmentQueue(maxNumFragments);
        try {
            String markedUpText;
            String tokenText;
            int endOffset;
            int startOffset;
            int lastEndOffset = 0;
            this.textFragmenter.start(text);
            TokenGroup tokenGroup = new TokenGroup();
            Token token = tokenStream.next();
            while (token != null && token.startOffset() < this.maxDocBytesToAnalyze) {
                if (tokenGroup.numTokens > 0 && tokenGroup.isDistinct(token)) {
                    startOffset = tokenGroup.matchStartOffset;
                    endOffset = tokenGroup.matchEndOffset;
                    tokenText = text.substring(startOffset, endOffset);
                    markedUpText = this.formatter.highlightTerm(this.encoder.encodeText(tokenText), tokenGroup);
                    if (startOffset > lastEndOffset) {
                        newText.append(this.encoder.encodeText(text.substring(lastEndOffset, startOffset)));
                    }
                    newText.append(markedUpText);
                    lastEndOffset = Math.max(endOffset, lastEndOffset);
                    tokenGroup.clear();
                    if (this.textFragmenter.isNewFragment(token)) {
                        currentFrag.setScore(this.fragmentScorer.getFragmentScore());
                        currentFrag.textEndPos = newText.length();
                        currentFrag = new TextFragment(newText, newText.length(), docFrags.size());
                        this.fragmentScorer.startFragment(currentFrag);
                        docFrags.add(currentFrag);
                    }
                }
                tokenGroup.addToken(token, this.fragmentScorer.getTokenScore(token));
                token = tokenStream.next();
            }
            currentFrag.setScore(this.fragmentScorer.getFragmentScore());
            if (tokenGroup.numTokens > 0) {
                startOffset = tokenGroup.matchStartOffset;
                endOffset = tokenGroup.matchEndOffset;
                tokenText = text.substring(startOffset, endOffset);
                markedUpText = this.formatter.highlightTerm(this.encoder.encodeText(tokenText), tokenGroup);
                if (startOffset > lastEndOffset) {
                    newText.append(this.encoder.encodeText(text.substring(lastEndOffset, startOffset)));
                }
                newText.append(markedUpText);
                lastEndOffset = Math.max(lastEndOffset, endOffset);
            }
            if (lastEndOffset < text.length() && text.length() < this.maxDocBytesToAnalyze) {
                newText.append(this.encoder.encodeText(text.substring(lastEndOffset)));
            }
            currentFrag.textEndPos = newText.length();
            Iterator i = docFrags.iterator();
            while (i.hasNext()) {
                currentFrag = (TextFragment)i.next();
                fragQueue.insert(currentFrag);
            }
            TextFragment[] frag = new TextFragment[fragQueue.size()];
            for (int i2 = frag.length - 1; i2 >= 0; --i2) {
                frag[i2] = (TextFragment)fragQueue.pop();
            }
            if (mergeContiguousFragments) {
                this.mergeContiguousFragments(frag);
                ArrayList<TextFragment> fragTexts = new ArrayList<TextFragment>();
                for (int i3 = 0; i3 < frag.length; ++i3) {
                    if (frag[i3] == null || !(frag[i3].getScore() > 0.0f)) continue;
                    fragTexts.add(frag[i3]);
                }
                frag = fragTexts.toArray(new TextFragment[0]);
            }
            TextFragment[] textFragmentArray = frag;
            return textFragmentArray;
        }
        finally {
            if (tokenStream != null) {
                try {
                    tokenStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void mergeContiguousFragments(TextFragment[] frag) {
        if (frag.length > 1) {
            boolean mergingStillBeingDone;
            do {
                mergingStillBeingDone = false;
                block1: for (int i = 0; i < frag.length; ++i) {
                    if (frag[i] == null) continue;
                    for (int x = 0; x < frag.length; ++x) {
                        int worstScoringFragNum;
                        int bestScoringFragNum;
                        if (frag[x] == null) continue;
                        if (frag[i] == null) continue block1;
                        TextFragment frag1 = null;
                        TextFragment frag2 = null;
                        int frag1Num = 0;
                        int frag2Num = 0;
                        if (frag[i].follows(frag[x])) {
                            frag1 = frag[x];
                            frag1Num = x;
                            frag2 = frag[i];
                            frag2Num = i;
                        } else if (frag[x].follows(frag[i])) {
                            frag1 = frag[i];
                            frag1Num = i;
                            frag2 = frag[x];
                            frag2Num = x;
                        }
                        if (frag1 == null) continue;
                        if (frag1.getScore() > frag2.getScore()) {
                            bestScoringFragNum = frag1Num;
                            worstScoringFragNum = frag2Num;
                        } else {
                            bestScoringFragNum = frag2Num;
                            worstScoringFragNum = frag1Num;
                        }
                        frag1.merge(frag2);
                        frag[worstScoringFragNum] = null;
                        mergingStillBeingDone = true;
                        frag[bestScoringFragNum] = frag1;
                    }
                }
            } while (mergingStillBeingDone);
        }
    }

    public final String getBestFragments(TokenStream tokenStream, String text, int maxNumFragments, String separator) throws IOException {
        String[] sections = this.getBestFragments(tokenStream, text, maxNumFragments);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < sections.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(sections[i]);
        }
        return result.toString();
    }

    public int getMaxDocBytesToAnalyze() {
        return this.maxDocBytesToAnalyze;
    }

    public void setMaxDocBytesToAnalyze(int byteCount) {
        this.maxDocBytesToAnalyze = byteCount;
    }

    public Fragmenter getTextFragmenter() {
        return this.textFragmenter;
    }

    public void setTextFragmenter(Fragmenter fragmenter) {
        this.textFragmenter = fragmenter;
    }

    public Scorer getFragmentScorer() {
        return this.fragmentScorer;
    }

    public void setFragmentScorer(Scorer scorer) {
        this.fragmentScorer = scorer;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }
}

