/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.util;

import java.util.Map;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.tools.MObjectHelper;
import org.eclipse.smila.utils.digest.DigestHelper;

public final class ConnectivityHashFactory {
    private static ConnectivityHashFactory s_instance;

    private ConnectivityHashFactory() {
    }

    public static ConnectivityHashFactory getInstance() {
        if (s_instance == null) {
            s_instance = new ConnectivityHashFactory();
        }
        return s_instance;
    }

    public String createHash(Attribute[] hashAttributes) {
        if (hashAttributes == null || hashAttributes.length == 0) {
            throw new IllegalArgumentException("Parameter hashAttributes must not be null or empty");
        }
        return this.createHash(hashAttributes, null);
    }

    public String createHash(Map<String, ?> hashAttachments) {
        if (hashAttachments == null || hashAttachments.isEmpty()) {
            throw new IllegalArgumentException("Parameter hashAttachments must not be null or empty");
        }
        return this.createHash(null, hashAttachments);
    }

    public String createHash(Attribute[] hashAttributes, Map<String, ?> hashAttachments) {
        if (!(hashAttributes != null && hashAttributes.length != 0 || hashAttachments != null && !hashAttachments.isEmpty())) {
            throw new IllegalArgumentException("Parameters hashAttributes and hashAttachments must not both be null or empty");
        }
        StringBuilder buffer = new StringBuilder();
        if (hashAttributes != null) {
            Attribute[] attributeArray = hashAttributes;
            int n = hashAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                String value = MObjectHelper.glueLiterals((Attribute)attribute);
                buffer.append(attribute.getName()).append('=').append(value).append(';');
                ++n2;
            }
        }
        if (hashAttachments != null) {
            for (String attachmentName : hashAttachments.keySet()) {
                Object attachmentValue = hashAttachments.get(attachmentName);
                if (attachmentValue instanceof String) {
                    buffer.append(attachmentName).append('=').append(attachmentValue).append(';');
                    continue;
                }
                if (attachmentValue instanceof byte[]) {
                    buffer.append(attachmentName).append('=').append(DigestHelper.calculateDigest((byte[])((byte[])attachmentValue))).append(';');
                    continue;
                }
                throw new IllegalArgumentException("Attachments must be of type String or byte[]");
            }
        }
        return DigestHelper.calculateDigest((String)buffer.toString());
    }

    public String createHash(String value) {
        return DigestHelper.calculateDigest((String)value);
    }
}

