/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.util;

import java.util.Map;
import org.eclipse.smila.connectivity.framework.CrawlerCallback;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.connectivity.framework.util.ConnectivityHashFactory;
import org.eclipse.smila.connectivity.framework.util.ConnectivityIdFactory;
import org.eclipse.smila.connectivity.framework.util.internal.DataReferenceImpl;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Attribute;

public final class DataReferenceFactory {
    private static DataReferenceFactory s_instance;

    private DataReferenceFactory() {
    }

    public static DataReferenceFactory getInstance() {
        if (s_instance == null) {
            s_instance = new DataReferenceFactory();
        }
        return s_instance;
    }

    public DataReference createDataReference(CrawlerCallback ccb, String dataSourceId, Attribute[] idAttributes, Attribute[] hashAttributes) {
        return this.createDataReference(ccb, dataSourceId, idAttributes, hashAttributes, null);
    }

    public DataReference createDataReference(CrawlerCallback ccb, String dataSourceId, Attribute[] idAttributes, Map<String, ?> hashAttachments) {
        return this.createDataReference(ccb, dataSourceId, idAttributes, null, hashAttachments);
    }

    public DataReference createDataReference(CrawlerCallback ccb, String dataSourceId, Attribute[] idAttributes, Attribute[] hashAttributes, Map<String, ?> hashAttachments) {
        Id id = ConnectivityIdFactory.getInstance().createId(dataSourceId, idAttributes);
        String hash = ConnectivityHashFactory.getInstance().createHash(hashAttributes, hashAttachments);
        return this.createDataReference(ccb, id, hash);
    }

    public DataReference createDataReference(CrawlerCallback ccb, Id id, String hash) {
        return new DataReferenceImpl(ccb, id, hash);
    }
}

