/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.util.internal;

import org.eclipse.smila.connectivity.framework.CrawlerCallback;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.InvalidTypeException;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;

public class DataReferenceImpl
implements DataReference {
    private Id _id;
    private String _hash;
    private CrawlerCallback _callback;
    private final RecordFactory _recordFactory = RecordFactory.DEFAULT_INSTANCE;

    public DataReferenceImpl(CrawlerCallback callback, Id id, String hash) {
        if (callback == null) {
            throw new IllegalArgumentException("Parameter callback must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Parameter id must not be null");
        }
        if (hash == null) {
            throw new IllegalArgumentException("Parameter hash must not be null");
        }
        this._callback = callback;
        this._id = id;
        this._hash = hash;
    }

    @Override
    public Id getId() {
        return this._id;
    }

    @Override
    public String getHash() {
        return this._hash;
    }

    @Override
    public Record getRecord() throws CrawlerException, CrawlerCriticalException, InvalidTypeException {
        String[] attachmenNames;
        Record record = this._recordFactory.createRecord();
        record.setId(this._id);
        record.setMetadata(this._callback.getMObject(this._id));
        String[] stringArray = attachmenNames = this._callback.getAttachmentNames(this._id);
        int n = attachmenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            record.setAttachment(name, this._callback.getAttachment(this._id, name));
            ++n2;
        }
        return record;
    }

    @Override
    public void dispose() {
        this._callback.dispose(this._id);
    }
}

