/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.pipelets.ATransformationPipelet;

public class CopyPipelet
extends ATransformationPipelet {
    private static final String PROPERTY_MODE = "mode";
    private final Log _log = LogFactory.getLog(this.getClass());
    private Mode _mode = Mode.COPY;

    @Override
    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        super.configure(configuration);
        String mode = (String)configuration.getPropertyFirstValue(PROPERTY_MODE);
        if (mode != null) {
            this._mode = Mode.valueOf(mode);
        }
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                Id id = idArray[n2];
                try {
                    String srcValue = this.readStringInput(blackboard, id);
                    if (srcValue != null) {
                        this.storeResult(blackboard, id, srcValue);
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("copied value from input " + (Object)((Object)this._inputType) + " " + this._inputName + " to " + (Object)((Object)this._outputType) + " " + this._outputName));
                        }
                    }
                    if (Mode.MOVE.equals((Object)this._mode)) {
                        if (this.isReadFromAttribute()) {
                            blackboard.removeLiterals(id, new Path(this.getInputName()));
                        } else {
                            blackboard.removeAttachment(id, this.getInputName());
                        }
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("deleted value of input " + (Object)((Object)this._inputType) + " " + this._inputName));
                        }
                    }
                }
                catch (Exception ex) {
                    this._log.error((Object)("Error processing ID " + id), (Throwable)ex);
                }
                ++n2;
            }
        }
        return recordIds;
    }

    private static enum Mode {
        COPY,
        MOVE;

    }
}

