/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.common.mimetype.MimeTypeIdentifier;
import org.eclipse.smila.common.mimetype.MimeTypeParseException;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.ProcessingService;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.configuration.PipeletConfigurationLoader;
import org.eclipse.smila.utils.config.ConfigUtils;

public class MimeTypeIdentifyService
implements ProcessingService {
    public static final String BUNDLE_NAME = "org.eclipse.smila.processing.pipelets";
    public static final String CONFIG_FILE = "MimeTypeConfig.xml";
    public static final String FILE_EXTENSION_ATTRIBUTE = "FileExtensionAttribute";
    public static final String CONTENT_ATTACHMENT = "ContentAttachment";
    public static final String META_DATA_ATTRIBUTE = "MetaDataAttribute";
    public static final String MIME_TYPE_ATTRIBUTE = "MimeTypeAttribute";
    private final Log _log = LogFactory.getLog(MimeTypeIdentifyService.class);
    private String _extensionAttributeName;
    private String _contentAttachmentName;
    private String _metaDataAttributeName;
    private String _mimeTypeAttributeName;
    private PipeletConfiguration _configuration;
    private MimeTypeIdentifier _mimeTypeIdentifier;
    private final Pattern _contentTypePattern = Pattern.compile("^CONTENT-TYPE\\s*:\\s*([^\\s;=]+)(?:.|\\s)*$", 2);

    public void setMimeTypeIdentifier(MimeTypeIdentifier mimeTypeIdentifier) {
        this._mimeTypeIdentifier = mimeTypeIdentifier;
    }

    public void unsetMimeTypeIdentifier(MimeTypeIdentifier mimeTypeIdentifier) {
        if (this._mimeTypeIdentifier == mimeTypeIdentifier) {
            this._mimeTypeIdentifier = null;
        }
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (this._configuration == null) {
            this.readConfiguration();
            this._extensionAttributeName = (String)this._configuration.getPropertyFirstValue(FILE_EXTENSION_ATTRIBUTE);
            this._contentAttachmentName = (String)this._configuration.getPropertyFirstValue(CONTENT_ATTACHMENT);
            this._metaDataAttributeName = (String)this._configuration.getPropertyFirstValue(META_DATA_ATTRIBUTE);
            this._mimeTypeAttributeName = (String)this._configuration.getPropertyFirstValueNotNull(MIME_TYPE_ATTRIBUTE);
            if (this._extensionAttributeName == null && this._contentAttachmentName == null && this._metaDataAttributeName == null) {
                throw new ProcessingException("One of the config properties FileExtensionAttribute, ContentAttachment or MetaDataAttribute have to be specified!");
            }
        }
        Id[] idArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Id id = idArray[n2];
                try {
                    this.identifyAndStore(blackboard, id);
                }
                catch (Exception ex) {
                    if (!this._log.isErrorEnabled()) break block5;
                    this._log.error((Object)("error identifying MimeType for record " + id), (Throwable)ex);
                }
            }
            ++n2;
        }
        return recordIds;
    }

    private void identifyAndStore(Blackboard blackboard, Id id) throws BlackboardAccessException, MimeTypeParseException {
        String mimeType = null;
        if (mimeType == null) {
            Path path;
            if (this._extensionAttributeName != null && this._contentAttachmentName != null) {
                String extension = null;
                byte[] content = null;
                Path path2 = new Path(this._extensionAttributeName);
                if (blackboard.hasAttribute(id, path2)) {
                    extension = blackboard.getLiteral(id, path2).getStringValue();
                }
                if (blackboard.hasAttachment(id, this._contentAttachmentName)) {
                    content = blackboard.getAttachment(id, this._contentAttachmentName);
                }
                mimeType = this._mimeTypeIdentifier.identify(content, extension);
            } else if (this._extensionAttributeName != null) {
                String extension;
                path = new Path(this._extensionAttributeName);
                if (blackboard.hasAttribute(id, path) && (extension = blackboard.getLiteral(id, path).getStringValue()) != null) {
                    mimeType = this._mimeTypeIdentifier.identify(extension);
                }
            } else if (this._contentAttachmentName != null && blackboard.hasAttachment(id, this._contentAttachmentName)) {
                byte[] content = blackboard.getAttachment(id, this._contentAttachmentName);
                mimeType = this._mimeTypeIdentifier.identify(content);
            }
            if (mimeType == null && this._metaDataAttributeName != null && blackboard.hasAttribute(id, path = new Path(this._metaDataAttributeName))) {
                List metaDataList = blackboard.getLiterals(id, path);
                for (Literal metaData : metaDataList) {
                    Matcher matcher;
                    String metaDataValue = metaData.getStringValue();
                    if (metaDataValue == null || !(matcher = this._contentTypePattern.matcher(metaDataValue)).find()) continue;
                    mimeType = matcher.group(1);
                    break;
                }
            }
            if (mimeType != null) {
                Literal literal = RecordFactory.DEFAULT_INSTANCE.createLiteral();
                literal.setStringValue(mimeType);
                blackboard.setLiteral(id, new Path(this._mimeTypeAttributeName), literal);
            } else if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("Unable to identify MimeType for Id " + id + ". No values found for " + FILE_EXTENSION_ATTRIBUTE));
            }
        }
    }

    private void readConfiguration() throws ProcessingException {
        InputStream configurationFileStream = null;
        try {
            try {
                configurationFileStream = ConfigUtils.getConfigStream((String)BUNDLE_NAME, (String)CONFIG_FILE);
                Unmarshaller unmarshaller = PipeletConfigurationLoader.createPipeletConfigurationUnmarshaller();
                this._configuration = (PipeletConfiguration)unmarshaller.unmarshal(configurationFileStream);
            }
            catch (Exception ex) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"Could not read configuration property file MimeTypeConfig.xml", (Throwable)ex);
                }
                throw new ProcessingException("Could not read configuration property file MimeTypeConfig.xml", (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configurationFileStream);
    }
}

