/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.blackboard.path.PathStep;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SimplePipelet;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;

public class SetAnnotationPipelet
implements SimplePipelet {
    public static final String PROP_PATH = "Path";
    public static final String PROP_NAME = "Name";
    public static final String PROP_ANONVALUE = "AnonValue";
    public static final String PROP_NAMEDVALUE = "NamedValue:";
    private final Log _log = LogFactory.getLog(SetAnnotationPipelet.class);
    private Path _attributePath;
    private String _annotationName;
    private final Map<String, String> _namedValues = new HashMap<String, String>();
    private final List<String> _anonValues = new ArrayList<String>();

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        List properties = configuration.getProperties();
        for (PipeletConfiguration.Property property : properties) {
            String stringValue;
            List list;
            String value;
            String name = property.getName();
            if (PROP_PATH.equals(name)) {
                value = property.getValue().toString();
                this.setAttributePath(value);
                continue;
            }
            if (PROP_NAME.equals(name)) {
                value = property.getValue().toString();
                this.setAnnotationName(value);
                continue;
            }
            if (PROP_ANONVALUE.equals(name)) {
                list = property.getValues();
                for (Object value2 : list) {
                    stringValue = (String)value2;
                    this.addAnonValue(stringValue);
                }
                continue;
            }
            if (name.startsWith(PROP_NAMEDVALUE)) {
                list = property.getValues();
                for (Object value2 : list) {
                    stringValue = (String)value2;
                    this.putNamedValue(name, stringValue);
                }
                continue;
            }
            this._log.warn((Object)("Unknown property name " + name));
        }
        if (this._annotationName == null) {
            this._log.error((Object)"No annotation name specified: Please set property Name");
            throw new ProcessingException("SetAnnotationsPipelet: No annotation name specified: Please set property Name");
        }
    }

    protected void putNamedValue(String name, String value) {
        String valueName = name.substring(PROP_NAMEDVALUE.length());
        this._namedValues.put(valueName, value);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("annotation namedValues = " + this._namedValues));
        }
    }

    protected void addAnonValue(String value) {
        this._anonValues.add(value);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("annotation anonValues = " + this._anonValues));
        }
    }

    protected void setAnnotationName(String value) {
        this._annotationName = value;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("annotation name = " + this._annotationName));
        }
    }

    protected void setAttributePath(String value) {
        this._attributePath = new Path(value);
        if (this._attributePath != null && this._attributePath.length() > 0) {
            PathStep step = this._attributePath.get(this._attributePath.length() - 1);
            this._attributePath.up().add(new PathStep(step.getName(), -1));
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("annotation path = " + this._attributePath));
        }
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                Id id = idArray[n2];
                this.setAnnotations(blackboard, id);
                ++n2;
            }
        }
        return recordIds;
    }

    private void setAnnotations(Blackboard blackboard, Id id) {
        try {
            Annotation annotation = blackboard.createAnnotation(id);
            if (!this._anonValues.isEmpty()) {
                annotation.setAnonValues(this._anonValues);
            }
            if (!this._namedValues.isEmpty()) {
                for (Map.Entry<String, String> entry : this._namedValues.entrySet()) {
                    annotation.setNamedValue(entry.getKey(), entry.getValue());
                }
            }
            blackboard.setAnnotation(id, this._attributePath, this._annotationName, annotation);
        }
        catch (BlackboardAccessException ex) {
            this._log.error((Object)("Error setting annotation on record " + id), (Throwable)ex);
        }
    }
}

