/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SimplePipelet;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;

public class SubAttributeExtractorPipelet
implements SimplePipelet {
    public static final String PROPPERTY_INPUT_PATH = "inputPath";
    public static final String PROPPERTY_OUTPUT_PATH = "outputPath";
    public static final String PROPPERTY_MODE = "mode";
    public static final String PROPPERTY_SEPARATOR = "separator";
    public static final String DEFAULT_SEPARATOR = " ";
    private final Log _log = LogFactory.getLog(SubAttributeExtractorPipelet.class);
    private Path _inputPath;
    private Path _outputPath;
    private Mode _mode;
    private String _separator;

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        this._inputPath = new Path((String)configuration.getPropertyFirstValueNotNull(PROPPERTY_INPUT_PATH));
        this._outputPath = new Path((String)configuration.getPropertyFirstValueNotNull(PROPPERTY_OUTPUT_PATH));
        this._mode = Mode.valueOf((String)configuration.getPropertyFirstValueNotNull(PROPPERTY_MODE));
        this._separator = (String)configuration.getPropertyFirstValue(PROPPERTY_SEPARATOR);
        if (this._separator == null) {
            this._separator = DEFAULT_SEPARATOR;
        }
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    Id id = idArray[n2];
                    try {
                        if (blackboard.hasAttribute(id, this._inputPath)) {
                            this.setAttributeValues(blackboard, id, blackboard.getLiterals(id, this._inputPath));
                        } else if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)("Could not find attribute with path " + this._inputPath + " in record " + id));
                        }
                    }
                    catch (Exception e) {
                        if (!this._log.isErrorEnabled()) break block7;
                        this._log.error((Object)("Error while processing record " + id), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return recordIds;
    }

    public Path getInputPath() {
        return this._inputPath;
    }

    public Path getOutputPath() {
        return this._outputPath;
    }

    public String getMode() {
        return this._mode.name();
    }

    public String getSeparator() {
        return this._separator;
    }

    private void setAttributeValues(Blackboard blackboard, Id id, List<Literal> values) throws BlackboardAccessException {
        if (values != null && !values.isEmpty()) {
            switch (this._mode) {
                case FIRST: {
                    blackboard.setLiteral(id, this._outputPath, values.get(0));
                    break;
                }
                case LAST: {
                    blackboard.setLiteral(id, this._outputPath, values.get(values.size() - 1));
                    break;
                }
                case ALL_AS_LIST: {
                    blackboard.setLiterals(id, this._outputPath, values);
                    break;
                }
                case ALL_AS_ONE: {
                    blackboard.setLiteral(id, this._outputPath, this.concat(blackboard.getRecord(id).getFactory(), values));
                    break;
                }
                default: {
                    if (!this._log.isErrorEnabled()) break;
                    this._log.error((Object)("Error while processing record " + id + ". Invalid mode " + (Object)((Object)this._mode)));
                }
            }
        }
    }

    private Literal concat(RecordFactory factory, List<Literal> values) {
        StringBuffer buffer = new StringBuffer();
        for (Literal value : values) {
            String stringValue = value.getStringValue();
            if (buffer.length() > 0) {
                buffer.append(this._separator);
            }
            buffer.append(stringValue);
        }
        Literal literal = factory.createLiteral();
        literal.setStringValue(buffer.toString());
        return literal;
    }

    private static enum Mode {
        FIRST,
        LAST,
        ALL_AS_LIST,
        ALL_AS_ONE;

    }
}

