/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.security;

import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.security.SecurityAnnotations;

public final class SecurityAnnotation {
    private MObject _mObject;
    private Annotation _annotation;
    private RecordFactory _factory;

    public SecurityAnnotation(Record record) {
        this(record.getMetadata(), record.getFactory());
    }

    public SecurityAnnotation(MObject mObject) {
        this(mObject, null);
    }

    public SecurityAnnotation(MObject mObject, RecordFactory factory) {
        this._mObject = mObject;
        this._factory = factory != null ? factory : RecordFactory.DEFAULT_INSTANCE;
    }

    public Annotation getAccessRights() {
        if (this._annotation == null) {
            this._annotation = this.ensureAnnotation((Annotatable)this._mObject, "ACCESS_RIGHTS");
        }
        return this._annotation;
    }

    public Annotation getAccessRights(SecurityAnnotations.AccessRightType accessRightType) {
        return this.ensureAnnotation((Annotatable)this.getAccessRights(), accessRightType.name());
    }

    public Annotation getAccessRights(SecurityAnnotations.AccessRightType accessRightType, SecurityAnnotations.EntityType entityType) {
        Annotation annotation = this.ensureAnnotation((Annotatable)this.getAccessRights(), accessRightType.name());
        return this.ensureAnnotation((Annotatable)annotation, entityType.name());
    }

    public void add(SecurityAnnotations.AccessRightType accessRightType, SecurityAnnotations.EntityType entityType, String entity) {
        Annotation annotation = this.getAccessRights(accessRightType, entityType);
        annotation.addAnonValue(entity);
    }

    public void remove() {
        this._mObject.removeAnnotations("ACCESS_RIGHTS");
    }

    public void remove(SecurityAnnotations.AccessRightType accessRightType) {
        this.getAccessRights().removeAnnotations(accessRightType.name());
    }

    public void remove(SecurityAnnotations.AccessRightType accessRightType, SecurityAnnotations.EntityType entityType) {
        this.getAccessRights(accessRightType).removeAnnotations(entityType.name());
    }

    public void remove(SecurityAnnotations.AccessRightType accessRightType, SecurityAnnotations.EntityType entityType, String entity) {
        this.getAccessRights(accessRightType, entityType).removeAnonValue(entity);
    }

    private Annotation ensureAnnotation(Annotatable annotatable, String name) {
        if (annotatable.hasAnnotation(name)) {
            return annotatable.getAnnotation(name);
        }
        Annotation annotation = this._factory.createAnnotation();
        annotatable.setAnnotation(name, annotation);
        return annotation;
    }
}

