/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.tomcat.starter;

import java.io.File;
import org.apache.catalina.Host;
import org.apache.catalina.Server;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.tomcat.starter.Catalina2;
import org.eclipse.smila.tomcat.starter.TomcatService;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class TomcatServiceImpl
implements TomcatService {
    public static final String BUNDLE_NAME = "org.eclipse.smila.tomcat";
    private String _catalinaHome;
    private Catalina _catalina;
    private Embedded _embedded;
    private Host _host;
    private final Log _log = LogFactory.getLog(TomcatServiceImpl.class);

    protected void activate(ComponentContext context) {
        this.start();
    }

    protected void deactivate(ComponentContext context) {
        this.stop();
    }

    @Override
    public void start() {
        this.setCatalinaHome();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(Server.class.getClassLoader());
                this._catalina = new Catalina2();
                this._catalina.setCatalinaBase(this._catalinaHome);
                this._catalina.setCatalinaHome(this._catalinaHome);
                this._catalina.setConfigFile(String.valueOf(this._catalinaHome) + "/conf/server.xml");
                this._catalina.start();
            }
            catch (Exception e) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"Error starting Tomcat server", (Throwable)e);
                }
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public void stop() {
        if (this._catalina != null) {
            block3: {
                try {
                    this._catalina.stop();
                    this._catalina = null;
                }
                catch (Throwable e) {
                    if (!this._log.isErrorEnabled()) break block3;
                    this._log.error((Object)"Error stopping Tomcat server", e);
                }
            }
            this._catalina = null;
        }
    }

    private synchronized void setCatalinaHome() {
        if (this._catalinaHome == null) {
            File configFolder = ConfigUtils.getConfigurationFolder();
            this._catalinaHome = String.valueOf(configFolder.getAbsolutePath()) + "/" + BUNDLE_NAME + "/";
        }
    }
}

