/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.search;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.smila.search.utils.search.DFieldCodec;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.DTextField;
import org.eclipse.smila.search.utils.search.ITFParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DTextFieldCodec {
    protected static DTextField decode(Element element) throws DSearchException {
        DTextField dTextField = new DTextField();
        DFieldCodec.decodeStandardValues(dTextField, element);
        dTextField.setText(element.getAttribute("Text"));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if ("Parameter".equals(nl.item(i).getLocalName())) {
                dTextField.setParameter((ITFParameter)DFieldCodec.getParameter((Element)nl.item(i)));
            }
            ++i;
        }
        return dTextField;
    }

    protected static Element encode(DTextField dTextField, Element element) throws DSearchException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/Search", "Field");
        el.setAttribute("xsi:type", "FTText");
        DFieldCodec.encodeStandardValues(dTextField, el);
        el.setAttribute("Text", dTextField.getText());
        if (dTextField.getParameter() != null) {
            Class encoder = dTextField.getParameter().getCodecClass();
            Method m = null;
            if (encoder != null) {
                try {
                    m = encoder.getMethod("encode", ITFParameter.class, Element.class);
                }
                catch (NoSuchMethodException e) {
                    throw new DSearchException("unable to locate encoder method", e);
                }
                try {
                    m.invoke(null, dTextField.getParameter(), el);
                }
                catch (InvocationTargetException e) {
                    throw new DSearchException("unable to invoke encoder method", e);
                }
                catch (IllegalAccessException e) {
                    throw new DSearchException("unable to invoke encoder method", e);
                }
            }
        }
        element.appendChild(el);
        return el;
    }
}

