/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.blackboard;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterNotFoundException;

public interface Blackboard {
    public void commit() throws BlackboardAccessException;

    public void invalidate();

    public void create(Id var1);

    public void load(Id var1) throws BlackboardAccessException;

    public void setRecord(Record var1) throws BlackboardAccessException;

    public Id split(Id var1, String var2) throws BlackboardAccessException;

    public void commit(Id var1) throws BlackboardAccessException;

    public void invalidate(Id var1);

    public Literal createLiteral(Id var1) throws BlackboardAccessException;

    public Annotation createAnnotation(Id var1) throws BlackboardAccessException;

    public Iterator<String> getAttributeNames(Id var1, Path var2) throws BlackboardAccessException;

    public Iterator<String> getAttributeNames(Id var1) throws BlackboardAccessException;

    public boolean hasAttribute(Id var1, Path var2) throws BlackboardAccessException;

    public boolean hasLiterals(Id var1, Path var2) throws BlackboardAccessException;

    public int getLiteralsSize(Id var1, Path var2) throws BlackboardAccessException;

    public List<Literal> getLiterals(Id var1, Path var2) throws BlackboardAccessException;

    public Literal getLiteral(Id var1, Path var2) throws BlackboardAccessException;

    public void setLiterals(Id var1, Path var2, List<Literal> var3) throws BlackboardAccessException;

    public void setLiteral(Id var1, Path var2, Literal var3) throws BlackboardAccessException;

    public void addLiteral(Id var1, Path var2, Literal var3) throws BlackboardAccessException;

    public void removeLiteral(Id var1, Path var2) throws BlackboardAccessException;

    public void removeLiterals(Id var1, Path var2) throws BlackboardAccessException;

    public boolean hasObjects(Id var1, Path var2) throws BlackboardAccessException;

    public int getObjectSize(Id var1, Path var2) throws BlackboardAccessException;

    public void removeObject(Id var1, Path var2) throws BlackboardAccessException;

    public void removeObjects(Id var1, Path var2) throws BlackboardAccessException;

    public String getObjectSemanticType(Id var1, Path var2) throws BlackboardAccessException;

    public void setObjectSemanticType(Id var1, Path var2, String var3) throws BlackboardAccessException;

    public Iterator<String> getAnnotationNames(Id var1, Path var2) throws BlackboardAccessException;

    public boolean hasAnnotations(Id var1, Path var2) throws BlackboardAccessException;

    public boolean hasAnnotation(Id var1, Path var2, String var3) throws BlackboardAccessException;

    public List<Annotation> getAnnotations(Id var1, Path var2, String var3) throws BlackboardAccessException;

    public Annotation getAnnotation(Id var1, Path var2, String var3) throws BlackboardAccessException;

    public void setAnnotations(Id var1, Path var2, String var3, List<Annotation> var4) throws BlackboardAccessException;

    public void setAnnotation(Id var1, Path var2, String var3, Annotation var4) throws BlackboardAccessException;

    public void addAnnotation(Id var1, Path var2, String var3, Annotation var4) throws BlackboardAccessException;

    public void removeAnnotation(Id var1, Path var2, String var3) throws BlackboardAccessException;

    public void removeAnnotations(Id var1, Path var2) throws BlackboardAccessException;

    public boolean hasAttachment(Id var1, String var2) throws BlackboardAccessException;

    public byte[] getAttachment(Id var1, String var2) throws BlackboardAccessException;

    public InputStream getAttachmentAsStream(Id var1, String var2) throws BlackboardAccessException;

    public File getAttachmentAsFile(Id var1, String var2) throws BlackboardAccessException;

    public void setAttachment(Id var1, String var2, byte[] var3) throws BlackboardAccessException;

    public void setAttachmentFromStream(Id var1, String var2, InputStream var3) throws BlackboardAccessException;

    public void setAttachmentFromFile(Id var1, String var2, File var3) throws BlackboardAccessException;

    public void removeAttachment(Id var1, String var2) throws BlackboardAccessException;

    public boolean hasGlobalNote(String var1) throws BlackboardAccessException;

    public Serializable getGlobalNote(String var1) throws BlackboardAccessException;

    public void setGlobalNote(String var1, Serializable var2) throws BlackboardAccessException;

    public boolean hasRecordNote(Id var1, String var2) throws BlackboardAccessException;

    public Serializable getRecordNote(Id var1, String var2) throws BlackboardAccessException;

    public void setRecordNote(Id var1, String var2, Serializable var3) throws BlackboardAccessException;

    public void synchronize(Record var1) throws BlackboardAccessException;

    public Record getRecord(Id var1) throws BlackboardAccessException;

    public Record getRecord(Id var1, String var2) throws BlackboardAccessException, RecordFilterNotFoundException;

    public Record filterRecord(Record var1, String var2) throws RecordFilterNotFoundException;
}

