/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.servlet;

import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.IdFactory;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SearchMessage;
import org.eclipse.smila.processing.SearchPipelet;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.parameters.ParameterAccessor;

public class MockSearchPipelet
implements SearchPipelet {
    public static final int MAX_TOTAL_HITS = 123;
    public static final int MAX_INDEX_SIZE = 12345;
    public static final Path QUERY = new Path("query");
    public static final Path QUERY_ANNOTATION = new Path().add("query", -1);
    public static final Path TITLE = new Path("title");
    public static final String PREFIX = "Result #";
    public static final String PREFIX_BLIND = "... Lorem ipsum dolor sit amet, ";
    public static final String SUFFIX_BLIND = ", consectetuer adipiscing elit ... ";
    public static final String PREFIX_HIGHLIGHT = "<b>";
    public static final String SUFFIX_HIGHLIGHT = "</b>";
    private final Log _log = LogFactory.getLog(this.getClass());
    private PipeletConfiguration _configuration;

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public SearchMessage process(Blackboard blackboard, SearchMessage message) throws ProcessingException {
        if (message.hasQuery()) {
            ParameterAccessor parameters = new ParameterAccessor(blackboard, message.getQuery());
            parameters.setPipeletConfiguration(this._configuration);
            String query = parameters.getQuery();
            int resultSize = parameters.getResultSize();
            int resultOffset = parameters.getResultOffset();
            double threshold = parameters.getThreshold();
            if (query == null || query.trim().length() == 0) {
                message.setRecords(new Id[0]);
                try {
                    this.setTotalHits(blackboard, message.getQuery(), 0);
                }
                catch (BlackboardAccessException ex) {
                    this._log.error((Object)ex);
                }
            } else {
                ArrayList<Id> results = new ArrayList<Id>(resultSize);
                int i = 0;
                while (i < resultSize) {
                    int position = resultOffset + i;
                    String value = PREFIX + position;
                    double relevance = 1.0 - (double)position / 123.0;
                    if (relevance >= threshold) {
                        try {
                            Id result = IdFactory.DEFAULT_INSTANCE.createId("file", "file_" + i + ".html");
                            blackboard.load(result);
                            Literal literal = blackboard.createLiteral(result);
                            literal.setStringValue(value);
                            blackboard.addLiteral(result, TITLE, literal);
                            this.setRelevance(blackboard, result, relevance);
                            this.setRecordHighlighting(blackboard, result, "... Lorem ipsum dolor sit amet, <b>" + query + SUFFIX_HIGHLIGHT + " #" + position + SUFFIX_BLIND, relevance);
                            results.add(result);
                        }
                        catch (BlackboardAccessException ex) {
                            this._log.error((Object)ex);
                        }
                    }
                    ++i;
                }
                int totalHits = (int)((1.0 - threshold) * 123.0);
                try {
                    this.setTotalHits(blackboard, message.getQuery(), totalHits);
                    this.setTerms(blackboard, message.getQuery(), query);
                    this.setFacets(blackboard, message.getQuery(), query, totalHits);
                    this.setIndexSize(blackboard, message.getQuery(), 12345);
                }
                catch (BlackboardAccessException ex) {
                    this._log.error((Object)ex);
                }
                message.setRecords(results);
            }
        }
        return message;
    }

    private void setTotalHits(Blackboard blackboard, Id record, int noOfHits) throws BlackboardAccessException {
        Annotation resultAnno = this.ensureRecordAnnotation(blackboard, record, "result");
        resultAnno.setNamedValue("totalHits", Integer.toString(noOfHits));
    }

    private void setIndexSize(Blackboard blackboard, Id record, int indexSize) throws BlackboardAccessException {
        Annotation resultAnno = this.ensureRecordAnnotation(blackboard, record, "result");
        resultAnno.setNamedValue("indexSize", Integer.toString(indexSize));
    }

    private void setRelevance(Blackboard blackboard, Id record, double relevance) throws BlackboardAccessException {
        Annotation resultAnno = this.ensureRecordAnnotation(blackboard, record, "result");
        resultAnno.setNamedValue("relevance", Double.toString(relevance));
    }

    private void setTerms(Blackboard blackboard, Id record, String text) throws BlackboardAccessException {
        if (text != null) {
            Literal queryLit = blackboard.createLiteral(record);
            queryLit.setStringValue(text);
            blackboard.setLiteral(record, QUERY, queryLit);
            String[] tokens = text.split(" ");
            int position = 0;
            int i = 0;
            while (i < tokens.length) {
                Annotation term = blackboard.createAnnotation(record);
                term.setNamedValue("token", tokens[i]);
                term.setNamedValue("concept", tokens[i].toUpperCase());
                term.setNamedValue("startWord", Integer.toString(i));
                term.setNamedValue("endWord", Integer.toString(i));
                term.setNamedValue("start", Integer.toString(position));
                term.setNamedValue("end", Integer.toString(position += tokens[i].length()));
                ++position;
                term.setNamedValue("pos", "word");
                term.setNamedValue("method", "test");
                term.setNamedValue("target", TITLE.getName(0));
                blackboard.addAnnotation(record, QUERY_ANNOTATION, "terms", term);
                ++i;
            }
        }
    }

    private void setFacets(Blackboard blackboard, Id record, String text, int totalHits) throws BlackboardAccessException {
        if (text != null) {
            Random rnd = new Random(System.nanoTime());
            String[] tokens = text.split(" ");
            int i = 0;
            while (i < tokens.length) {
                Annotation facet = blackboard.createAnnotation(record);
                facet.setNamedValue("name", tokens[i]);
                facet.setNamedValue("filter", " + " + tokens[i]);
                int facetCount = i < tokens.length - 1 ? rnd.nextInt(totalHits) : totalHits;
                facet.setNamedValue("count", Integer.toString(facetCount));
                totalHits -= facetCount;
                blackboard.addAnnotation(record, QUERY_ANNOTATION, "facets", facet);
                ++i;
            }
        }
    }

    private void setRecordHighlighting(Blackboard blackboard, Id record, String text, double quality) throws BlackboardAccessException {
        if (text != null) {
            Annotation highlight = this.ensureRecordAnnotation(blackboard, record, "highlight");
            highlight.setNamedValue("text", text);
            String[] tokens = text.split(" ");
            int position = 0;
            int i = 0;
            while (i < tokens.length) {
                Annotation highlightPos = blackboard.createAnnotation(record);
                highlightPos.setNamedValue("start", Integer.toString(position));
                highlightPos.setNamedValue("end", Integer.toString(position += tokens[i].length()));
                ++position;
                highlightPos.setNamedValue("quality", Double.toString(quality));
                highlightPos.setNamedValue("method", "test");
                highlightPos.setNamedValue("group", Integer.toString(i));
                highlight.addAnnotation("positions", highlightPos);
                ++i;
            }
        }
    }

    private Annotation ensureRecordAnnotation(Blackboard blackboard, Id record, String name) throws BlackboardAccessException {
        Annotation annotation = blackboard.getAnnotation(record, null, name);
        if (annotation == null) {
            annotation = blackboard.createAnnotation(record);
            blackboard.setAnnotation(record, null, name, annotation);
        }
        return annotation;
    }
}

