/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.CamelInvocationHandler;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SendBeforeInterceptor
implements MethodInterceptor,
CamelContextAware,
InitializingBean,
DisposableBean {
    private String uri;
    private CamelContext camelContext;
    private CamelInvocationHandler invocationHandler;
    private Producer producer;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.invocationHandler.invoke(invocation.getThis(), invocation.getMethod(), invocation.getArguments());
        return invocation.proceed();
    }

    public void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull((Object)this.uri, (String)"uri");
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)this.camelContext, (String)this.uri);
        this.producer = endpoint.createProducer();
        this.producer.start();
        this.invocationHandler = new CamelInvocationHandler(endpoint, this.producer);
    }

    public void destroy() throws Exception {
        if (this.producer != null) {
            this.producer.stop();
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

